// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of storage types for an Amazon OpenSearch Service domain that are available for a given intance type.
 */
public class StorageType private constructor(builder: Builder) {
    /**
     * The storage sub-type, such as `gp3` or `io1`.
     */
    public val storageSubTypeName: kotlin.String? = builder.storageSubTypeName
    /**
     * Limits that are applicable for the given storage type.
     */
    public val storageTypeLimits: List<StorageTypeLimit>? = builder.storageTypeLimits
    /**
     * The name of the storage type.
     */
    public val storageTypeName: kotlin.String? = builder.storageTypeName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.StorageType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageType(")
        append("storageSubTypeName=$storageSubTypeName,")
        append("storageTypeLimits=$storageTypeLimits,")
        append("storageTypeName=$storageTypeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = storageSubTypeName?.hashCode() ?: 0
        result = 31 * result + (storageTypeLimits?.hashCode() ?: 0)
        result = 31 * result + (storageTypeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageType

        if (storageSubTypeName != other.storageSubTypeName) return false
        if (storageTypeLimits != other.storageTypeLimits) return false
        if (storageTypeName != other.storageTypeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.StorageType = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The storage sub-type, such as `gp3` or `io1`.
         */
        public var storageSubTypeName: kotlin.String? = null
        /**
         * Limits that are applicable for the given storage type.
         */
        public var storageTypeLimits: List<StorageTypeLimit>? = null
        /**
         * The name of the storage type.
         */
        public var storageTypeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.StorageType) : this() {
            this.storageSubTypeName = x.storageSubTypeName
            this.storageTypeLimits = x.storageTypeLimits
            this.storageTypeName = x.storageTypeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.StorageType = StorageType(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
