// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for the request parameters to the `StartServiceSoftwareUpdate` operation.
 */
public class StartServiceSoftwareUpdateRequest private constructor(builder: Builder) {
    /**
     * The Epoch timestamp when you want the service software update to start. You only need to specify this parameter if you set `ScheduleAt` to `TIMESTAMP`.
     */
    public val desiredStartTime: kotlin.Long? = builder.desiredStartTime
    /**
     * The name of the domain that you want to update to the latest service software.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * When to start the service software update.
     * + `NOW` - Immediately schedules the update to happen in the current hour if there's capacity available.
     * + `TIMESTAMP` - Lets you specify a custom date and time to apply the update. If you specify this value, you must also provide a value for `DesiredStartTime`.
     * + `OFF_PEAK_WINDOW` - Marks the update to be picked up during an upcoming off-peak window. There's no guarantee that the update will happen during the next immediate window. Depending on capacity, it might happen in subsequent days.
     *
     * Default: `NOW` if you don't specify a value for `DesiredStartTime`, and `TIMESTAMP` if you do.
     */
    public val scheduleAt: aws.sdk.kotlin.services.opensearch.model.ScheduleAt? = builder.scheduleAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.StartServiceSoftwareUpdateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartServiceSoftwareUpdateRequest(")
        append("desiredStartTime=$desiredStartTime,")
        append("domainName=$domainName,")
        append("scheduleAt=$scheduleAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredStartTime?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (scheduleAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartServiceSoftwareUpdateRequest

        if (desiredStartTime != other.desiredStartTime) return false
        if (domainName != other.domainName) return false
        if (scheduleAt != other.scheduleAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.StartServiceSoftwareUpdateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Epoch timestamp when you want the service software update to start. You only need to specify this parameter if you set `ScheduleAt` to `TIMESTAMP`.
         */
        public var desiredStartTime: kotlin.Long? = null
        /**
         * The name of the domain that you want to update to the latest service software.
         */
        public var domainName: kotlin.String? = null
        /**
         * When to start the service software update.
         * + `NOW` - Immediately schedules the update to happen in the current hour if there's capacity available.
         * + `TIMESTAMP` - Lets you specify a custom date and time to apply the update. If you specify this value, you must also provide a value for `DesiredStartTime`.
         * + `OFF_PEAK_WINDOW` - Marks the update to be picked up during an upcoming off-peak window. There's no guarantee that the update will happen during the next immediate window. Depending on capacity, it might happen in subsequent days.
         *
         * Default: `NOW` if you don't specify a value for `DesiredStartTime`, and `TIMESTAMP` if you do.
         */
        public var scheduleAt: aws.sdk.kotlin.services.opensearch.model.ScheduleAt? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.StartServiceSoftwareUpdateRequest) : this() {
            this.desiredStartTime = x.desiredStartTime
            this.domainName = x.domainName
            this.scheduleAt = x.scheduleAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.StartServiceSoftwareUpdateRequest = StartServiceSoftwareUpdateRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
