// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details of an OpenSearch Reserved Instance.
 */
public class ReservedInstance private constructor(builder: Builder) {
    /**
     * The unique identifier of the billing subscription.
     */
    public val billingSubscriptionId: kotlin.Long? = builder.billingSubscriptionId
    /**
     * The currency code for the offering.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The duration, in seconds, for which the OpenSearch instance is reserved.
     */
    public val duration: kotlin.Int = builder.duration
    /**
     * The upfront fixed charge you will paid to purchase the specific Reserved Instance offering.
     */
    public val fixedPrice: kotlin.Double? = builder.fixedPrice
    /**
     * The number of OpenSearch instances that have been reserved.
     */
    public val instanceCount: kotlin.Int = builder.instanceCount
    /**
     * The OpenSearch instance type offered by theReserved Instance offering.
     */
    public val instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = builder.instanceType
    /**
     * The payment option as defined in the Reserved Instance offering.
     */
    public val paymentOption: aws.sdk.kotlin.services.opensearch.model.ReservedInstancePaymentOption? = builder.paymentOption
    /**
     * The recurring charge to your account, regardless of whether you create any domains using the Reserved Instance offering.
     */
    public val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The customer-specified identifier to track this reservation.
     */
    public val reservationName: kotlin.String? = builder.reservationName
    /**
     * The unique identifier for the reservation.
     */
    public val reservedInstanceId: kotlin.String? = builder.reservedInstanceId
    /**
     * The unique identifier of the Reserved Instance offering.
     */
    public val reservedInstanceOfferingId: kotlin.String? = builder.reservedInstanceOfferingId
    /**
     * The date and time when the reservation was purchased.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the Reserved Instance.
     */
    public val state: kotlin.String? = builder.state
    /**
     * The hourly rate at which you're charged for the domain using this Reserved Instance.
     */
    public val usagePrice: kotlin.Double? = builder.usagePrice

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ReservedInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstance(")
        append("billingSubscriptionId=$billingSubscriptionId,")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("paymentOption=$paymentOption,")
        append("recurringCharges=$recurringCharges,")
        append("reservationName=$reservationName,")
        append("reservedInstanceId=$reservedInstanceId,")
        append("reservedInstanceOfferingId=$reservedInstanceOfferingId,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("usagePrice=$usagePrice")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = billingSubscriptionId?.hashCode() ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (duration)
        result = 31 * result + (fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceCount)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservationName?.hashCode() ?: 0)
        result = 31 * result + (reservedInstanceId?.hashCode() ?: 0)
        result = 31 * result + (reservedInstanceOfferingId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedInstance

        if (billingSubscriptionId != other.billingSubscriptionId) return false
        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (!(fixedPrice?.equals(other.fixedPrice) ?: (other.fixedPrice == null))) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (paymentOption != other.paymentOption) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservationName != other.reservationName) return false
        if (reservedInstanceId != other.reservedInstanceId) return false
        if (reservedInstanceOfferingId != other.reservedInstanceOfferingId) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (!(usagePrice?.equals(other.usagePrice) ?: (other.usagePrice == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ReservedInstance = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the billing subscription.
         */
        public var billingSubscriptionId: kotlin.Long? = null
        /**
         * The currency code for the offering.
         */
        public var currencyCode: kotlin.String? = null
        /**
         * The duration, in seconds, for which the OpenSearch instance is reserved.
         */
        public var duration: kotlin.Int = 0
        /**
         * The upfront fixed charge you will paid to purchase the specific Reserved Instance offering.
         */
        public var fixedPrice: kotlin.Double? = null
        /**
         * The number of OpenSearch instances that have been reserved.
         */
        public var instanceCount: kotlin.Int = 0
        /**
         * The OpenSearch instance type offered by theReserved Instance offering.
         */
        public var instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null
        /**
         * The payment option as defined in the Reserved Instance offering.
         */
        public var paymentOption: aws.sdk.kotlin.services.opensearch.model.ReservedInstancePaymentOption? = null
        /**
         * The recurring charge to your account, regardless of whether you create any domains using the Reserved Instance offering.
         */
        public var recurringCharges: List<RecurringCharge>? = null
        /**
         * The customer-specified identifier to track this reservation.
         */
        public var reservationName: kotlin.String? = null
        /**
         * The unique identifier for the reservation.
         */
        public var reservedInstanceId: kotlin.String? = null
        /**
         * The unique identifier of the Reserved Instance offering.
         */
        public var reservedInstanceOfferingId: kotlin.String? = null
        /**
         * The date and time when the reservation was purchased.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the Reserved Instance.
         */
        public var state: kotlin.String? = null
        /**
         * The hourly rate at which you're charged for the domain using this Reserved Instance.
         */
        public var usagePrice: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ReservedInstance) : this() {
            this.billingSubscriptionId = x.billingSubscriptionId
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.paymentOption = x.paymentOption
            this.recurringCharges = x.recurringCharges
            this.reservationName = x.reservationName
            this.reservedInstanceId = x.reservedInstanceId
            this.reservedInstanceOfferingId = x.reservedInstanceOfferingId
            this.startTime = x.startTime
            this.state = x.state
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ReservedInstance = ReservedInstance(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
