// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration parameters for a package.
 */
public class PackageConfiguration private constructor(builder: Builder) {
    /**
     * The configuration requirements for the package.
     */
    public val configurationRequirement: aws.sdk.kotlin.services.opensearch.model.RequirementLevel = requireNotNull(builder.configurationRequirement) { "A non-null value must be provided for configurationRequirement" }
    /**
     * The relative file path for the license associated with the package.
     */
    public val licenseFilepath: kotlin.String? = builder.licenseFilepath
    /**
     * The license requirements for the package.
     */
    public val licenseRequirement: aws.sdk.kotlin.services.opensearch.model.RequirementLevel = requireNotNull(builder.licenseRequirement) { "A non-null value must be provided for licenseRequirement" }
    /**
     * This indicates whether a B/G deployment is required for updating the configuration that the plugin is prerequisite for.
     */
    public val requiresRestartForConfigurationUpdate: kotlin.Boolean? = builder.requiresRestartForConfigurationUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.PackageConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PackageConfiguration(")
        append("configurationRequirement=$configurationRequirement,")
        append("licenseFilepath=$licenseFilepath,")
        append("licenseRequirement=$licenseRequirement,")
        append("requiresRestartForConfigurationUpdate=$requiresRestartForConfigurationUpdate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationRequirement.hashCode()
        result = 31 * result + (licenseFilepath?.hashCode() ?: 0)
        result = 31 * result + (licenseRequirement.hashCode())
        result = 31 * result + (requiresRestartForConfigurationUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PackageConfiguration

        if (configurationRequirement != other.configurationRequirement) return false
        if (licenseFilepath != other.licenseFilepath) return false
        if (licenseRequirement != other.licenseRequirement) return false
        if (requiresRestartForConfigurationUpdate != other.requiresRestartForConfigurationUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.PackageConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration requirements for the package.
         */
        public var configurationRequirement: aws.sdk.kotlin.services.opensearch.model.RequirementLevel? = null
        /**
         * The relative file path for the license associated with the package.
         */
        public var licenseFilepath: kotlin.String? = null
        /**
         * The license requirements for the package.
         */
        public var licenseRequirement: aws.sdk.kotlin.services.opensearch.model.RequirementLevel? = null
        /**
         * This indicates whether a B/G deployment is required for updating the configuration that the plugin is prerequisite for.
         */
        public var requiresRestartForConfigurationUpdate: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.PackageConfiguration) : this() {
            this.configurationRequirement = x.configurationRequirement
            this.licenseFilepath = x.licenseFilepath
            this.licenseRequirement = x.licenseRequirement
            this.requiresRestartForConfigurationUpdate = x.requiresRestartForConfigurationUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.PackageConfiguration = PackageConfiguration(this)

        internal fun correctErrors(): Builder {
            if (configurationRequirement == null) configurationRequirement = RequirementLevel.SdkUnknown("no value provided")
            if (licenseRequirement == null) licenseRequirement = RequirementLevel.SdkUnknown("no value provided")
            return this
        }
    }
}
