// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The status of an outbound cross-cluster connection.
 */
public class OutboundConnectionStatus private constructor(builder: Builder) {
    /**
     * Verbose information for the outbound connection.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The status code for the outbound connection. Can be one of the following:
     * + **VALIDATING** - The outbound connection request is being validated.
     * + **VALIDATION_FAILED** - Validation failed for the connection request.
     * + **PENDING_ACCEPTANCE**: Outbound connection request is validated and is not yet accepted by the remote domain owner.
     * + **APPROVED** - Outbound connection has been approved by the remote domain owner for getting provisioned.
     * + **PROVISIONING** - Outbound connection request is in process.
     * + **ACTIVE** - Outbound connection is active and ready to use.
     * + **REJECTING** - Outbound connection rejection by remote domain owner is in progress.
     * + **REJECTED** - Outbound connection request is rejected by remote domain owner.
     * + **DELETING** - Outbound connection deletion is in progress.
     * + **DELETED** - Outbound connection is deleted and can no longer be used.
     */
    public val statusCode: aws.sdk.kotlin.services.opensearch.model.OutboundConnectionStatusCode? = builder.statusCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.OutboundConnectionStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutboundConnectionStatus(")
        append("message=$message,")
        append("statusCode=$statusCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutboundConnectionStatus

        if (message != other.message) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.OutboundConnectionStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Verbose information for the outbound connection.
         */
        public var message: kotlin.String? = null
        /**
         * The status code for the outbound connection. Can be one of the following:
         * + **VALIDATING** - The outbound connection request is being validated.
         * + **VALIDATION_FAILED** - Validation failed for the connection request.
         * + **PENDING_ACCEPTANCE**: Outbound connection request is validated and is not yet accepted by the remote domain owner.
         * + **APPROVED** - Outbound connection has been approved by the remote domain owner for getting provisioned.
         * + **PROVISIONING** - Outbound connection request is in process.
         * + **ACTIVE** - Outbound connection is active and ready to use.
         * + **REJECTING** - Outbound connection rejection by remote domain owner is in progress.
         * + **REJECTED** - Outbound connection request is rejected by remote domain owner.
         * + **DELETING** - Outbound connection deletion is in progress.
         * + **DELETED** - Outbound connection is deleted and can no longer be used.
         */
        public var statusCode: aws.sdk.kotlin.services.opensearch.model.OutboundConnectionStatusCode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.OutboundConnectionStatus) : this() {
            this.message = x.message
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.OutboundConnectionStatus = OutboundConnectionStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
