// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Options for a domain's [off-peak window](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html), during which OpenSearch Service can perform mandatory configuration changes on the domain.
 */
public class OffPeakWindowOptions private constructor(builder: Builder) {
    /**
     * Whether to enable an off-peak window.
     *
     * This option is only available when modifying a domain created prior to February 16, 2023, not when creating a new domain. All domains created after this date have the off-peak window enabled by default. You can't disable the off-peak window after it's enabled for a domain.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Off-peak window settings for the domain.
     */
    public val offPeakWindow: aws.sdk.kotlin.services.opensearch.model.OffPeakWindow? = builder.offPeakWindow

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OffPeakWindowOptions(")
        append("enabled=$enabled,")
        append("offPeakWindow=$offPeakWindow")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (offPeakWindow?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OffPeakWindowOptions

        if (enabled != other.enabled) return false
        if (offPeakWindow != other.offPeakWindow) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether to enable an off-peak window.
         *
         * This option is only available when modifying a domain created prior to February 16, 2023, not when creating a new domain. All domains created after this date have the off-peak window enabled by default. You can't disable the off-peak window after it's enabled for a domain.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Off-peak window settings for the domain.
         */
        public var offPeakWindow: aws.sdk.kotlin.services.opensearch.model.OffPeakWindow? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptions) : this() {
            this.enabled = x.enabled
            this.offPeakWindow = x.offPeakWindow
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptions = OffPeakWindowOptions(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.OffPeakWindow] inside the given [block]
         */
        public fun offPeakWindow(block: aws.sdk.kotlin.services.opensearch.model.OffPeakWindow.Builder.() -> kotlin.Unit) {
            this.offPeakWindow = aws.sdk.kotlin.services.opensearch.model.OffPeakWindow.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
