// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Lists all instance types and available features for a given OpenSearch or Elasticsearch version.
 */
public class InstanceTypeDetails private constructor(builder: Builder) {
    /**
     * Whether fine-grained access control is supported for the instance type.
     */
    public val advancedSecurityEnabled: kotlin.Boolean? = builder.advancedSecurityEnabled
    /**
     * Whether logging is supported for the instance type.
     */
    public val appLogsEnabled: kotlin.Boolean? = builder.appLogsEnabled
    /**
     * The supported Availability Zones for the instance type.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Whether Amazon Cognito access is supported for the instance type.
     */
    public val cognitoEnabled: kotlin.Boolean? = builder.cognitoEnabled
    /**
     * Whether encryption at rest and node-to-node encryption are supported for the instance type.
     */
    public val encryptionEnabled: kotlin.Boolean? = builder.encryptionEnabled
    /**
     * Whether the instance acts as a data node, a dedicated master node, or an UltraWarm node.
     */
    public val instanceRole: List<String>? = builder.instanceRole
    /**
     * The instance type.
     */
    public val instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = builder.instanceType
    /**
     * Whether UltraWarm is supported for the instance type.
     */
    public val warmEnabled: kotlin.Boolean? = builder.warmEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.InstanceTypeDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceTypeDetails(")
        append("advancedSecurityEnabled=$advancedSecurityEnabled,")
        append("appLogsEnabled=$appLogsEnabled,")
        append("availabilityZones=$availabilityZones,")
        append("cognitoEnabled=$cognitoEnabled,")
        append("encryptionEnabled=$encryptionEnabled,")
        append("instanceRole=$instanceRole,")
        append("instanceType=$instanceType,")
        append("warmEnabled=$warmEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedSecurityEnabled?.hashCode() ?: 0
        result = 31 * result + (appLogsEnabled?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (cognitoEnabled?.hashCode() ?: 0)
        result = 31 * result + (encryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (instanceRole?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (warmEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceTypeDetails

        if (advancedSecurityEnabled != other.advancedSecurityEnabled) return false
        if (appLogsEnabled != other.appLogsEnabled) return false
        if (availabilityZones != other.availabilityZones) return false
        if (cognitoEnabled != other.cognitoEnabled) return false
        if (encryptionEnabled != other.encryptionEnabled) return false
        if (instanceRole != other.instanceRole) return false
        if (instanceType != other.instanceType) return false
        if (warmEnabled != other.warmEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.InstanceTypeDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether fine-grained access control is supported for the instance type.
         */
        public var advancedSecurityEnabled: kotlin.Boolean? = null
        /**
         * Whether logging is supported for the instance type.
         */
        public var appLogsEnabled: kotlin.Boolean? = null
        /**
         * The supported Availability Zones for the instance type.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Whether Amazon Cognito access is supported for the instance type.
         */
        public var cognitoEnabled: kotlin.Boolean? = null
        /**
         * Whether encryption at rest and node-to-node encryption are supported for the instance type.
         */
        public var encryptionEnabled: kotlin.Boolean? = null
        /**
         * Whether the instance acts as a data node, a dedicated master node, or an UltraWarm node.
         */
        public var instanceRole: List<String>? = null
        /**
         * The instance type.
         */
        public var instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null
        /**
         * Whether UltraWarm is supported for the instance type.
         */
        public var warmEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.InstanceTypeDetails) : this() {
            this.advancedSecurityEnabled = x.advancedSecurityEnabled
            this.appLogsEnabled = x.appLogsEnabled
            this.availabilityZones = x.availabilityZones
            this.cognitoEnabled = x.cognitoEnabled
            this.encryptionEnabled = x.encryptionEnabled
            this.instanceRole = x.instanceRole
            this.instanceType = x.instanceType
            this.warmEnabled = x.warmEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.InstanceTypeDetails = InstanceTypeDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
