// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration settings for enabling and managing IAM Identity Center.
 */
public class IdentityCenterOptionsInput private constructor(builder: Builder) {
    /**
     * Indicates whether IAM Identity Center is enabled for API access in Amazon OpenSearch Service.
     */
    public val enabledApiAccess: kotlin.Boolean? = builder.enabledApiAccess
    /**
     * The ARN of the IAM Identity Center instance used to create an OpenSearch UI application that uses IAM Identity Center for authentication.
     */
    public val identityCenterInstanceArn: kotlin.String? = builder.identityCenterInstanceArn
    /**
     * Specifies the attribute that contains the backend role identifier (such as group name or group ID) in IAM Identity Center.
     */
    public val rolesKey: aws.sdk.kotlin.services.opensearch.model.RolesKeyIdCOption? = builder.rolesKey
    /**
     * Specifies the attribute that contains the subject identifier (such as username, user ID, or email) in IAM Identity Center.
     */
    public val subjectKey: aws.sdk.kotlin.services.opensearch.model.SubjectKeyIdCOption? = builder.subjectKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityCenterOptionsInput(")
        append("enabledApiAccess=$enabledApiAccess,")
        append("identityCenterInstanceArn=$identityCenterInstanceArn,")
        append("rolesKey=$rolesKey,")
        append("subjectKey=$subjectKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabledApiAccess?.hashCode() ?: 0
        result = 31 * result + (identityCenterInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (rolesKey?.hashCode() ?: 0)
        result = 31 * result + (subjectKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityCenterOptionsInput

        if (enabledApiAccess != other.enabledApiAccess) return false
        if (identityCenterInstanceArn != other.identityCenterInstanceArn) return false
        if (rolesKey != other.rolesKey) return false
        if (subjectKey != other.subjectKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether IAM Identity Center is enabled for API access in Amazon OpenSearch Service.
         */
        public var enabledApiAccess: kotlin.Boolean? = null
        /**
         * The ARN of the IAM Identity Center instance used to create an OpenSearch UI application that uses IAM Identity Center for authentication.
         */
        public var identityCenterInstanceArn: kotlin.String? = null
        /**
         * Specifies the attribute that contains the backend role identifier (such as group name or group ID) in IAM Identity Center.
         */
        public var rolesKey: aws.sdk.kotlin.services.opensearch.model.RolesKeyIdCOption? = null
        /**
         * Specifies the attribute that contains the subject identifier (such as username, user ID, or email) in IAM Identity Center.
         */
        public var subjectKey: aws.sdk.kotlin.services.opensearch.model.SubjectKeyIdCOption? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsInput) : this() {
            this.enabledApiAccess = x.enabledApiAccess
            this.identityCenterInstanceArn = x.identityCenterInstanceArn
            this.rolesKey = x.rolesKey
            this.subjectKey = x.subjectKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsInput = IdentityCenterOptionsInput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
