// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetApplicationResponse private constructor(builder: Builder) {
    /**
     * The configuration settings of the OpenSearch application.
     */
    public val appConfigs: List<AppConfig>? = builder.appConfigs
    /**
     * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp when the OpenSearch application was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The data sources associated with the OpenSearch application.
     */
    public val dataSources: List<DataSource>? = builder.dataSources
    /**
     * The endpoint URL of the OpenSearch application.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The IAM Identity Center settings configured for the OpenSearch application.
     */
    public val iamIdentityCenterOptions: aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions? = builder.iamIdentityCenterOptions
    /**
     * The unique identifier of the OpenSearch application.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The timestamp of the last update to the OpenSearch application.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The name of the OpenSearch application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current status of the OpenSearch application. Possible values: `CREATING`, `UPDATING`, `DELETING`, `FAILED`, `ACTIVE`, and `DELETED`.
     */
    public val status: aws.sdk.kotlin.services.opensearch.model.ApplicationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.GetApplicationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetApplicationResponse(")
        append("appConfigs=$appConfigs,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("dataSources=$dataSources,")
        append("endpoint=$endpoint,")
        append("iamIdentityCenterOptions=$iamIdentityCenterOptions,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appConfigs?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (dataSources?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (iamIdentityCenterOptions?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetApplicationResponse

        if (appConfigs != other.appConfigs) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (dataSources != other.dataSources) return false
        if (endpoint != other.endpoint) return false
        if (iamIdentityCenterOptions != other.iamIdentityCenterOptions) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.GetApplicationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration settings of the OpenSearch application.
         */
        public var appConfigs: List<AppConfig>? = null
        /**
         * The Amazon Resource Name (ARN) of the domain. See [Identifiers for IAM Entities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html) in *Using Amazon Web Services Identity and Access Management* for more information.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp when the OpenSearch application was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data sources associated with the OpenSearch application.
         */
        public var dataSources: List<DataSource>? = null
        /**
         * The endpoint URL of the OpenSearch application.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The IAM Identity Center settings configured for the OpenSearch application.
         */
        public var iamIdentityCenterOptions: aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions? = null
        /**
         * The unique identifier of the OpenSearch application.
         */
        public var id: kotlin.String? = null
        /**
         * The timestamp of the last update to the OpenSearch application.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the OpenSearch application.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of the OpenSearch application. Possible values: `CREATING`, `UPDATING`, `DELETING`, `FAILED`, `ACTIVE`, and `DELETED`.
         */
        public var status: aws.sdk.kotlin.services.opensearch.model.ApplicationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.GetApplicationResponse) : this() {
            this.appConfigs = x.appConfigs
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.dataSources = x.dataSources
            this.endpoint = x.endpoint
            this.iamIdentityCenterOptions = x.iamIdentityCenterOptions
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.GetApplicationResponse = GetApplicationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions] inside the given [block]
         */
        public fun iamIdentityCenterOptions(block: aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions.Builder.() -> kotlin.Unit) {
            this.iamIdentityCenterOptions = aws.sdk.kotlin.services.opensearch.model.IamIdentityCenterOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
