// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for the parameters required to enable EBS-based storage for an OpenSearch Service domain.
 */
public class EbsOptions private constructor(builder: Builder) {
    /**
     * Indicates whether EBS volumes are attached to data nodes in an OpenSearch Service domain.
     */
    public val ebsEnabled: kotlin.Boolean? = builder.ebsEnabled
    /**
     * Specifies the baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the `gp3` and provisioned IOPS EBS volume types.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the `gp3` volume type.
     */
    public val throughput: kotlin.Int? = builder.throughput
    /**
     * Specifies the size (in GiB) of EBS volumes attached to data nodes.
     */
    public val volumeSize: kotlin.Int? = builder.volumeSize
    /**
     * Specifies the type of EBS volumes attached to data nodes.
     */
    public val volumeType: aws.sdk.kotlin.services.opensearch.model.VolumeType? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.EbsOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsOptions(")
        append("ebsEnabled=$ebsEnabled,")
        append("iops=$iops,")
        append("throughput=$throughput,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ebsEnabled?.hashCode() ?: 0
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsOptions

        if (ebsEnabled != other.ebsEnabled) return false
        if (iops != other.iops) return false
        if (throughput != other.throughput) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.EbsOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether EBS volumes are attached to data nodes in an OpenSearch Service domain.
         */
        public var ebsEnabled: kotlin.Boolean? = null
        /**
         * Specifies the baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the `gp3` and provisioned IOPS EBS volume types.
         */
        public var iops: kotlin.Int? = null
        /**
         * Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the `gp3` volume type.
         */
        public var throughput: kotlin.Int? = null
        /**
         * Specifies the size (in GiB) of EBS volumes attached to data nodes.
         */
        public var volumeSize: kotlin.Int? = null
        /**
         * Specifies the type of EBS volumes attached to data nodes.
         */
        public var volumeType: aws.sdk.kotlin.services.opensearch.model.VolumeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.EbsOptions) : this() {
            this.ebsEnabled = x.ebsEnabled
            this.iops = x.iops
            this.throughput = x.throughput
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.EbsOptions = EbsOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
