// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for the configuration of an OpenSearch Service domain.
 */
public class DomainConfig private constructor(builder: Builder) {
    /**
     * Specifies the access policies for the domain.
     */
    public val accessPolicies: aws.sdk.kotlin.services.opensearch.model.AccessPoliciesStatus? = builder.accessPolicies
    /**
     * Key-value pairs to specify advanced configuration options. For more information, see [Advanced options](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
     */
    public val advancedOptions: aws.sdk.kotlin.services.opensearch.model.AdvancedOptionsStatus? = builder.advancedOptions
    /**
     * Container for fine-grained access control settings for the domain.
     */
    public val advancedSecurityOptions: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsStatus? = builder.advancedSecurityOptions
    /**
     * Container for parameters required to enable all machine learning features.
     */
    public val aimlOptions: aws.sdk.kotlin.services.opensearch.model.AimlOptionsStatus? = builder.aimlOptions
    /**
     * Container for Auto-Tune settings for the domain.
     */
    public val autoTuneOptions: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsStatus? = builder.autoTuneOptions
    /**
     * Container for information about the progress of an existing configuration change.
     */
    public val changeProgressDetails: aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails? = builder.changeProgressDetails
    /**
     * Container for the cluster configuration of a the domain.
     */
    public val clusterConfig: aws.sdk.kotlin.services.opensearch.model.ClusterConfigStatus? = builder.clusterConfig
    /**
     * Container for Amazon Cognito options for the domain.
     */
    public val cognitoOptions: aws.sdk.kotlin.services.opensearch.model.CognitoOptionsStatus? = builder.cognitoOptions
    /**
     * Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
     */
    public val domainEndpointOptions: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptionsStatus? = builder.domainEndpointOptions
    /**
     * Container for EBS options configured for the domain.
     */
    public val ebsOptions: aws.sdk.kotlin.services.opensearch.model.EbsOptionsStatus? = builder.ebsOptions
    /**
     * Key-value pairs to enable encryption at rest.
     */
    public val encryptionAtRestOptions: aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptionsStatus? = builder.encryptionAtRestOptions
    /**
     * The OpenSearch or Elasticsearch version that the domain is running.
     */
    public val engineVersion: aws.sdk.kotlin.services.opensearch.model.VersionStatus? = builder.engineVersion
    /**
     * Configuration options for enabling and managing IAM Identity Center integration within a domain.
     */
    public val identityCenterOptions: aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsStatus? = builder.identityCenterOptions
    /**
     * Choose either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual stack, you can't change your address type later.
     */
    public val ipAddressType: aws.sdk.kotlin.services.opensearch.model.IpAddressTypeStatus? = builder.ipAddressType
    /**
     * Key-value pairs to configure log publishing.
     */
    public val logPublishingOptions: aws.sdk.kotlin.services.opensearch.model.LogPublishingOptionsStatus? = builder.logPublishingOptions
    /**
     * Information about the domain properties that are currently being modified.
     */
    public val modifyingProperties: List<ModifyingProperties>? = builder.modifyingProperties
    /**
     * Whether node-to-node encryption is enabled or disabled.
     */
    public val nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptionsStatus? = builder.nodeToNodeEncryptionOptions
    /**
     * Container for off-peak window options for the domain.
     */
    public val offPeakWindowOptions: aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptionsStatus? = builder.offPeakWindowOptions
    /**
     * DEPRECATED. Container for parameters required to configure automated snapshots of domain indexes.
     */
    public val snapshotOptions: aws.sdk.kotlin.services.opensearch.model.SnapshotOptionsStatus? = builder.snapshotOptions
    /**
     * Software update options for the domain.
     */
    public val softwareUpdateOptions: aws.sdk.kotlin.services.opensearch.model.SoftwareUpdateOptionsStatus? = builder.softwareUpdateOptions
    /**
     * The current VPC options for the domain and the status of any updates to their configuration.
     */
    public val vpcOptions: aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfoStatus? = builder.vpcOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DomainConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainConfig(")
        append("accessPolicies=$accessPolicies,")
        append("advancedOptions=$advancedOptions,")
        append("advancedSecurityOptions=$advancedSecurityOptions,")
        append("aimlOptions=$aimlOptions,")
        append("autoTuneOptions=$autoTuneOptions,")
        append("changeProgressDetails=$changeProgressDetails,")
        append("clusterConfig=$clusterConfig,")
        append("cognitoOptions=$cognitoOptions,")
        append("domainEndpointOptions=$domainEndpointOptions,")
        append("ebsOptions=$ebsOptions,")
        append("encryptionAtRestOptions=$encryptionAtRestOptions,")
        append("engineVersion=$engineVersion,")
        append("identityCenterOptions=$identityCenterOptions,")
        append("ipAddressType=$ipAddressType,")
        append("logPublishingOptions=$logPublishingOptions,")
        append("modifyingProperties=$modifyingProperties,")
        append("nodeToNodeEncryptionOptions=$nodeToNodeEncryptionOptions,")
        append("offPeakWindowOptions=$offPeakWindowOptions,")
        append("snapshotOptions=$snapshotOptions,")
        append("softwareUpdateOptions=$softwareUpdateOptions,")
        append("vpcOptions=$vpcOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicies?.hashCode() ?: 0
        result = 31 * result + (advancedOptions?.hashCode() ?: 0)
        result = 31 * result + (advancedSecurityOptions?.hashCode() ?: 0)
        result = 31 * result + (aimlOptions?.hashCode() ?: 0)
        result = 31 * result + (autoTuneOptions?.hashCode() ?: 0)
        result = 31 * result + (changeProgressDetails?.hashCode() ?: 0)
        result = 31 * result + (clusterConfig?.hashCode() ?: 0)
        result = 31 * result + (cognitoOptions?.hashCode() ?: 0)
        result = 31 * result + (domainEndpointOptions?.hashCode() ?: 0)
        result = 31 * result + (ebsOptions?.hashCode() ?: 0)
        result = 31 * result + (encryptionAtRestOptions?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (identityCenterOptions?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (logPublishingOptions?.hashCode() ?: 0)
        result = 31 * result + (modifyingProperties?.hashCode() ?: 0)
        result = 31 * result + (nodeToNodeEncryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (offPeakWindowOptions?.hashCode() ?: 0)
        result = 31 * result + (snapshotOptions?.hashCode() ?: 0)
        result = 31 * result + (softwareUpdateOptions?.hashCode() ?: 0)
        result = 31 * result + (vpcOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainConfig

        if (accessPolicies != other.accessPolicies) return false
        if (advancedOptions != other.advancedOptions) return false
        if (advancedSecurityOptions != other.advancedSecurityOptions) return false
        if (aimlOptions != other.aimlOptions) return false
        if (autoTuneOptions != other.autoTuneOptions) return false
        if (changeProgressDetails != other.changeProgressDetails) return false
        if (clusterConfig != other.clusterConfig) return false
        if (cognitoOptions != other.cognitoOptions) return false
        if (domainEndpointOptions != other.domainEndpointOptions) return false
        if (ebsOptions != other.ebsOptions) return false
        if (encryptionAtRestOptions != other.encryptionAtRestOptions) return false
        if (engineVersion != other.engineVersion) return false
        if (identityCenterOptions != other.identityCenterOptions) return false
        if (ipAddressType != other.ipAddressType) return false
        if (logPublishingOptions != other.logPublishingOptions) return false
        if (modifyingProperties != other.modifyingProperties) return false
        if (nodeToNodeEncryptionOptions != other.nodeToNodeEncryptionOptions) return false
        if (offPeakWindowOptions != other.offPeakWindowOptions) return false
        if (snapshotOptions != other.snapshotOptions) return false
        if (softwareUpdateOptions != other.softwareUpdateOptions) return false
        if (vpcOptions != other.vpcOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DomainConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the access policies for the domain.
         */
        public var accessPolicies: aws.sdk.kotlin.services.opensearch.model.AccessPoliciesStatus? = null
        /**
         * Key-value pairs to specify advanced configuration options. For more information, see [Advanced options](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
         */
        public var advancedOptions: aws.sdk.kotlin.services.opensearch.model.AdvancedOptionsStatus? = null
        /**
         * Container for fine-grained access control settings for the domain.
         */
        public var advancedSecurityOptions: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsStatus? = null
        /**
         * Container for parameters required to enable all machine learning features.
         */
        public var aimlOptions: aws.sdk.kotlin.services.opensearch.model.AimlOptionsStatus? = null
        /**
         * Container for Auto-Tune settings for the domain.
         */
        public var autoTuneOptions: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsStatus? = null
        /**
         * Container for information about the progress of an existing configuration change.
         */
        public var changeProgressDetails: aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails? = null
        /**
         * Container for the cluster configuration of a the domain.
         */
        public var clusterConfig: aws.sdk.kotlin.services.opensearch.model.ClusterConfigStatus? = null
        /**
         * Container for Amazon Cognito options for the domain.
         */
        public var cognitoOptions: aws.sdk.kotlin.services.opensearch.model.CognitoOptionsStatus? = null
        /**
         * Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
         */
        public var domainEndpointOptions: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptionsStatus? = null
        /**
         * Container for EBS options configured for the domain.
         */
        public var ebsOptions: aws.sdk.kotlin.services.opensearch.model.EbsOptionsStatus? = null
        /**
         * Key-value pairs to enable encryption at rest.
         */
        public var encryptionAtRestOptions: aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptionsStatus? = null
        /**
         * The OpenSearch or Elasticsearch version that the domain is running.
         */
        public var engineVersion: aws.sdk.kotlin.services.opensearch.model.VersionStatus? = null
        /**
         * Configuration options for enabling and managing IAM Identity Center integration within a domain.
         */
        public var identityCenterOptions: aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsStatus? = null
        /**
         * Choose either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual stack, you can't change your address type later.
         */
        public var ipAddressType: aws.sdk.kotlin.services.opensearch.model.IpAddressTypeStatus? = null
        /**
         * Key-value pairs to configure log publishing.
         */
        public var logPublishingOptions: aws.sdk.kotlin.services.opensearch.model.LogPublishingOptionsStatus? = null
        /**
         * Information about the domain properties that are currently being modified.
         */
        public var modifyingProperties: List<ModifyingProperties>? = null
        /**
         * Whether node-to-node encryption is enabled or disabled.
         */
        public var nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptionsStatus? = null
        /**
         * Container for off-peak window options for the domain.
         */
        public var offPeakWindowOptions: aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptionsStatus? = null
        /**
         * DEPRECATED. Container for parameters required to configure automated snapshots of domain indexes.
         */
        public var snapshotOptions: aws.sdk.kotlin.services.opensearch.model.SnapshotOptionsStatus? = null
        /**
         * Software update options for the domain.
         */
        public var softwareUpdateOptions: aws.sdk.kotlin.services.opensearch.model.SoftwareUpdateOptionsStatus? = null
        /**
         * The current VPC options for the domain and the status of any updates to their configuration.
         */
        public var vpcOptions: aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfoStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DomainConfig) : this() {
            this.accessPolicies = x.accessPolicies
            this.advancedOptions = x.advancedOptions
            this.advancedSecurityOptions = x.advancedSecurityOptions
            this.aimlOptions = x.aimlOptions
            this.autoTuneOptions = x.autoTuneOptions
            this.changeProgressDetails = x.changeProgressDetails
            this.clusterConfig = x.clusterConfig
            this.cognitoOptions = x.cognitoOptions
            this.domainEndpointOptions = x.domainEndpointOptions
            this.ebsOptions = x.ebsOptions
            this.encryptionAtRestOptions = x.encryptionAtRestOptions
            this.engineVersion = x.engineVersion
            this.identityCenterOptions = x.identityCenterOptions
            this.ipAddressType = x.ipAddressType
            this.logPublishingOptions = x.logPublishingOptions
            this.modifyingProperties = x.modifyingProperties
            this.nodeToNodeEncryptionOptions = x.nodeToNodeEncryptionOptions
            this.offPeakWindowOptions = x.offPeakWindowOptions
            this.snapshotOptions = x.snapshotOptions
            this.softwareUpdateOptions = x.softwareUpdateOptions
            this.vpcOptions = x.vpcOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DomainConfig = DomainConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.AccessPoliciesStatus] inside the given [block]
         */
        public fun accessPolicies(block: aws.sdk.kotlin.services.opensearch.model.AccessPoliciesStatus.Builder.() -> kotlin.Unit) {
            this.accessPolicies = aws.sdk.kotlin.services.opensearch.model.AccessPoliciesStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.AdvancedOptionsStatus] inside the given [block]
         */
        public fun advancedOptions(block: aws.sdk.kotlin.services.opensearch.model.AdvancedOptionsStatus.Builder.() -> kotlin.Unit) {
            this.advancedOptions = aws.sdk.kotlin.services.opensearch.model.AdvancedOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsStatus] inside the given [block]
         */
        public fun advancedSecurityOptions(block: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsStatus.Builder.() -> kotlin.Unit) {
            this.advancedSecurityOptions = aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.AimlOptionsStatus] inside the given [block]
         */
        public fun aimlOptions(block: aws.sdk.kotlin.services.opensearch.model.AimlOptionsStatus.Builder.() -> kotlin.Unit) {
            this.aimlOptions = aws.sdk.kotlin.services.opensearch.model.AimlOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsStatus] inside the given [block]
         */
        public fun autoTuneOptions(block: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsStatus.Builder.() -> kotlin.Unit) {
            this.autoTuneOptions = aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails] inside the given [block]
         */
        public fun changeProgressDetails(block: aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails.Builder.() -> kotlin.Unit) {
            this.changeProgressDetails = aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ClusterConfigStatus] inside the given [block]
         */
        public fun clusterConfig(block: aws.sdk.kotlin.services.opensearch.model.ClusterConfigStatus.Builder.() -> kotlin.Unit) {
            this.clusterConfig = aws.sdk.kotlin.services.opensearch.model.ClusterConfigStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.CognitoOptionsStatus] inside the given [block]
         */
        public fun cognitoOptions(block: aws.sdk.kotlin.services.opensearch.model.CognitoOptionsStatus.Builder.() -> kotlin.Unit) {
            this.cognitoOptions = aws.sdk.kotlin.services.opensearch.model.CognitoOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptionsStatus] inside the given [block]
         */
        public fun domainEndpointOptions(block: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptionsStatus.Builder.() -> kotlin.Unit) {
            this.domainEndpointOptions = aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.EbsOptionsStatus] inside the given [block]
         */
        public fun ebsOptions(block: aws.sdk.kotlin.services.opensearch.model.EbsOptionsStatus.Builder.() -> kotlin.Unit) {
            this.ebsOptions = aws.sdk.kotlin.services.opensearch.model.EbsOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptionsStatus] inside the given [block]
         */
        public fun encryptionAtRestOptions(block: aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptionsStatus.Builder.() -> kotlin.Unit) {
            this.encryptionAtRestOptions = aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.VersionStatus] inside the given [block]
         */
        public fun engineVersion(block: aws.sdk.kotlin.services.opensearch.model.VersionStatus.Builder.() -> kotlin.Unit) {
            this.engineVersion = aws.sdk.kotlin.services.opensearch.model.VersionStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsStatus] inside the given [block]
         */
        public fun identityCenterOptions(block: aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsStatus.Builder.() -> kotlin.Unit) {
            this.identityCenterOptions = aws.sdk.kotlin.services.opensearch.model.IdentityCenterOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.IpAddressTypeStatus] inside the given [block]
         */
        public fun ipAddressType(block: aws.sdk.kotlin.services.opensearch.model.IpAddressTypeStatus.Builder.() -> kotlin.Unit) {
            this.ipAddressType = aws.sdk.kotlin.services.opensearch.model.IpAddressTypeStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.LogPublishingOptionsStatus] inside the given [block]
         */
        public fun logPublishingOptions(block: aws.sdk.kotlin.services.opensearch.model.LogPublishingOptionsStatus.Builder.() -> kotlin.Unit) {
            this.logPublishingOptions = aws.sdk.kotlin.services.opensearch.model.LogPublishingOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptionsStatus] inside the given [block]
         */
        public fun nodeToNodeEncryptionOptions(block: aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptionsStatus.Builder.() -> kotlin.Unit) {
            this.nodeToNodeEncryptionOptions = aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptionsStatus] inside the given [block]
         */
        public fun offPeakWindowOptions(block: aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptionsStatus.Builder.() -> kotlin.Unit) {
            this.offPeakWindowOptions = aws.sdk.kotlin.services.opensearch.model.OffPeakWindowOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.SnapshotOptionsStatus] inside the given [block]
         */
        public fun snapshotOptions(block: aws.sdk.kotlin.services.opensearch.model.SnapshotOptionsStatus.Builder.() -> kotlin.Unit) {
            this.snapshotOptions = aws.sdk.kotlin.services.opensearch.model.SnapshotOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.SoftwareUpdateOptionsStatus] inside the given [block]
         */
        public fun softwareUpdateOptions(block: aws.sdk.kotlin.services.opensearch.model.SoftwareUpdateOptionsStatus.Builder.() -> kotlin.Unit) {
            this.softwareUpdateOptions = aws.sdk.kotlin.services.opensearch.model.SoftwareUpdateOptionsStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfoStatus] inside the given [block]
         */
        public fun vpcOptions(block: aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfoStatus.Builder.() -> kotlin.Unit) {
            this.vpcOptions = aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfoStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
