// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration details for a data source that can be directly queried.
 */
public class DirectQueryDataSource private constructor(builder: Builder) {
    /**
     * The unique, system-generated identifier that represents the data source.
     */
    public val dataSourceArn: kotlin.String? = builder.dataSourceArn
    /**
     * A unique, user-defined label to identify the data source within your OpenSearch Service environment.
     */
    public val dataSourceName: kotlin.String? = builder.dataSourceName
    /**
     * The supported Amazon Web Services service that is used as the source for direct queries in OpenSearch Service.
     */
    public val dataSourceType: aws.sdk.kotlin.services.opensearch.model.DirectQueryDataSourceType? = builder.dataSourceType
    /**
     * A description that provides additional context and details about the data source.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A list of Amazon Resource Names (ARNs) for the OpenSearch collections that are associated with the direct query data source.
     */
    public val openSearchArns: List<String>? = builder.openSearchArns
    /**
     * A list of tags attached to a direct query data source.
     */
    public val tagList: List<Tag>? = builder.tagList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DirectQueryDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DirectQueryDataSource(")
        append("dataSourceArn=$dataSourceArn,")
        append("dataSourceName=$dataSourceName,")
        append("dataSourceType=$dataSourceType,")
        append("description=$description,")
        append("openSearchArns=$openSearchArns,")
        append("tagList=$tagList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceArn?.hashCode() ?: 0
        result = 31 * result + (dataSourceName?.hashCode() ?: 0)
        result = 31 * result + (dataSourceType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (openSearchArns?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DirectQueryDataSource

        if (dataSourceArn != other.dataSourceArn) return false
        if (dataSourceName != other.dataSourceName) return false
        if (dataSourceType != other.dataSourceType) return false
        if (description != other.description) return false
        if (openSearchArns != other.openSearchArns) return false
        if (tagList != other.tagList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DirectQueryDataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique, system-generated identifier that represents the data source.
         */
        public var dataSourceArn: kotlin.String? = null
        /**
         * A unique, user-defined label to identify the data source within your OpenSearch Service environment.
         */
        public var dataSourceName: kotlin.String? = null
        /**
         * The supported Amazon Web Services service that is used as the source for direct queries in OpenSearch Service.
         */
        public var dataSourceType: aws.sdk.kotlin.services.opensearch.model.DirectQueryDataSourceType? = null
        /**
         * A description that provides additional context and details about the data source.
         */
        public var description: kotlin.String? = null
        /**
         * A list of Amazon Resource Names (ARNs) for the OpenSearch collections that are associated with the direct query data source.
         */
        public var openSearchArns: List<String>? = null
        /**
         * A list of tags attached to a direct query data source.
         */
        public var tagList: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DirectQueryDataSource) : this() {
            this.dataSourceArn = x.dataSourceArn
            this.dataSourceName = x.dataSourceName
            this.dataSourceType = x.dataSourceType
            this.description = x.description
            this.openSearchArns = x.openSearchArns
            this.tagList = x.tagList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DirectQueryDataSource = DirectQueryDataSource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
