// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The result of a `DescribeDomainHealth` request. Contains health information for the requested domain.
 */
public class DescribeDomainHealthResponse private constructor(builder: Builder) {
    /**
     * The number of active Availability Zones configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
     */
    public val activeAvailabilityZoneCount: kotlin.String? = builder.activeAvailabilityZoneCount
    /**
     * The number of Availability Zones configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
     */
    public val availabilityZoneCount: kotlin.String? = builder.availabilityZoneCount
    /**
     * The current health status of your cluster.
     * + `Red` - At least one primary shard is not allocated to any node.
     * + `Yellow` - All primary shards are allocated to nodes, but some replicas aren’t.
     * + `Green` - All primary shards and their replicas are allocated to nodes.
     * + `NotAvailable` - Unable to retrieve cluster health.
     */
    public val clusterHealth: aws.sdk.kotlin.services.opensearch.model.DomainHealth? = builder.clusterHealth
    /**
     * The number of data nodes configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
     */
    public val dataNodeCount: kotlin.String? = builder.dataNodeCount
    /**
     * A boolean that indicates if dedicated master nodes are activated for the domain.
     */
    public val dedicatedMaster: kotlin.Boolean? = builder.dedicatedMaster
    /**
     * The current state of the domain.
     * + `Processing` - The domain has updates in progress.
     * + `Active` - Requested changes have been processed and deployed to the domain.
     */
    public val domainState: aws.sdk.kotlin.services.opensearch.model.DomainState? = builder.domainState
    /**
     * A list of `EnvironmentInfo` for the domain.
     */
    public val environmentInformation: List<EnvironmentInfo>? = builder.environmentInformation
    /**
     * The number of nodes that can be elected as a master node. If dedicated master nodes is turned on, this value is the number of dedicated master nodes configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
     */
    public val masterEligibleNodeCount: kotlin.String? = builder.masterEligibleNodeCount
    /**
     * Indicates whether the domain has an elected master node.
     * + **Available** - The domain has an elected master node.
     * + **UnAvailable** - The master node hasn't yet been elected, and a quorum to elect a new master node hasn't been reached.
     */
    public val masterNode: aws.sdk.kotlin.services.opensearch.model.MasterNodeStatus? = builder.masterNode
    /**
     * The number of standby Availability Zones configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
     */
    public val standByAvailabilityZoneCount: kotlin.String? = builder.standByAvailabilityZoneCount
    /**
     * The total number of primary and replica shards for the domain.
     */
    public val totalShards: kotlin.String? = builder.totalShards
    /**
     * The total number of primary and replica shards not allocated to any of the nodes for the cluster.
     */
    public val totalUnAssignedShards: kotlin.String? = builder.totalUnAssignedShards
    /**
     * The number of warm nodes configured for the domain.
     */
    public val warmNodeCount: kotlin.String? = builder.warmNodeCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DescribeDomainHealthResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDomainHealthResponse(")
        append("activeAvailabilityZoneCount=$activeAvailabilityZoneCount,")
        append("availabilityZoneCount=$availabilityZoneCount,")
        append("clusterHealth=$clusterHealth,")
        append("dataNodeCount=$dataNodeCount,")
        append("dedicatedMaster=$dedicatedMaster,")
        append("domainState=$domainState,")
        append("environmentInformation=$environmentInformation,")
        append("masterEligibleNodeCount=$masterEligibleNodeCount,")
        append("masterNode=$masterNode,")
        append("standByAvailabilityZoneCount=$standByAvailabilityZoneCount,")
        append("totalShards=$totalShards,")
        append("totalUnAssignedShards=$totalUnAssignedShards,")
        append("warmNodeCount=$warmNodeCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeAvailabilityZoneCount?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneCount?.hashCode() ?: 0)
        result = 31 * result + (clusterHealth?.hashCode() ?: 0)
        result = 31 * result + (dataNodeCount?.hashCode() ?: 0)
        result = 31 * result + (dedicatedMaster?.hashCode() ?: 0)
        result = 31 * result + (domainState?.hashCode() ?: 0)
        result = 31 * result + (environmentInformation?.hashCode() ?: 0)
        result = 31 * result + (masterEligibleNodeCount?.hashCode() ?: 0)
        result = 31 * result + (masterNode?.hashCode() ?: 0)
        result = 31 * result + (standByAvailabilityZoneCount?.hashCode() ?: 0)
        result = 31 * result + (totalShards?.hashCode() ?: 0)
        result = 31 * result + (totalUnAssignedShards?.hashCode() ?: 0)
        result = 31 * result + (warmNodeCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDomainHealthResponse

        if (activeAvailabilityZoneCount != other.activeAvailabilityZoneCount) return false
        if (availabilityZoneCount != other.availabilityZoneCount) return false
        if (clusterHealth != other.clusterHealth) return false
        if (dataNodeCount != other.dataNodeCount) return false
        if (dedicatedMaster != other.dedicatedMaster) return false
        if (domainState != other.domainState) return false
        if (environmentInformation != other.environmentInformation) return false
        if (masterEligibleNodeCount != other.masterEligibleNodeCount) return false
        if (masterNode != other.masterNode) return false
        if (standByAvailabilityZoneCount != other.standByAvailabilityZoneCount) return false
        if (totalShards != other.totalShards) return false
        if (totalUnAssignedShards != other.totalUnAssignedShards) return false
        if (warmNodeCount != other.warmNodeCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DescribeDomainHealthResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of active Availability Zones configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
         */
        public var activeAvailabilityZoneCount: kotlin.String? = null
        /**
         * The number of Availability Zones configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
         */
        public var availabilityZoneCount: kotlin.String? = null
        /**
         * The current health status of your cluster.
         * + `Red` - At least one primary shard is not allocated to any node.
         * + `Yellow` - All primary shards are allocated to nodes, but some replicas aren’t.
         * + `Green` - All primary shards and their replicas are allocated to nodes.
         * + `NotAvailable` - Unable to retrieve cluster health.
         */
        public var clusterHealth: aws.sdk.kotlin.services.opensearch.model.DomainHealth? = null
        /**
         * The number of data nodes configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
         */
        public var dataNodeCount: kotlin.String? = null
        /**
         * A boolean that indicates if dedicated master nodes are activated for the domain.
         */
        public var dedicatedMaster: kotlin.Boolean? = null
        /**
         * The current state of the domain.
         * + `Processing` - The domain has updates in progress.
         * + `Active` - Requested changes have been processed and deployed to the domain.
         */
        public var domainState: aws.sdk.kotlin.services.opensearch.model.DomainState? = null
        /**
         * A list of `EnvironmentInfo` for the domain.
         */
        public var environmentInformation: List<EnvironmentInfo>? = null
        /**
         * The number of nodes that can be elected as a master node. If dedicated master nodes is turned on, this value is the number of dedicated master nodes configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
         */
        public var masterEligibleNodeCount: kotlin.String? = null
        /**
         * Indicates whether the domain has an elected master node.
         * + **Available** - The domain has an elected master node.
         * + **UnAvailable** - The master node hasn't yet been elected, and a quorum to elect a new master node hasn't been reached.
         */
        public var masterNode: aws.sdk.kotlin.services.opensearch.model.MasterNodeStatus? = null
        /**
         * The number of standby Availability Zones configured for the domain. If the service is unable to fetch this information, it will return `NotAvailable`.
         */
        public var standByAvailabilityZoneCount: kotlin.String? = null
        /**
         * The total number of primary and replica shards for the domain.
         */
        public var totalShards: kotlin.String? = null
        /**
         * The total number of primary and replica shards not allocated to any of the nodes for the cluster.
         */
        public var totalUnAssignedShards: kotlin.String? = null
        /**
         * The number of warm nodes configured for the domain.
         */
        public var warmNodeCount: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DescribeDomainHealthResponse) : this() {
            this.activeAvailabilityZoneCount = x.activeAvailabilityZoneCount
            this.availabilityZoneCount = x.availabilityZoneCount
            this.clusterHealth = x.clusterHealth
            this.dataNodeCount = x.dataNodeCount
            this.dedicatedMaster = x.dedicatedMaster
            this.domainState = x.domainState
            this.environmentInformation = x.environmentInformation
            this.masterEligibleNodeCount = x.masterEligibleNodeCount
            this.masterNode = x.masterNode
            this.standByAvailabilityZoneCount = x.standByAvailabilityZoneCount
            this.totalShards = x.totalShards
            this.totalUnAssignedShards = x.totalUnAssignedShards
            this.warmNodeCount = x.warmNodeCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DescribeDomainHealthResponse = DescribeDomainHealthResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
