// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for the parameters to the `DescribeDomainAutoTunes` operation.
 */
public class DescribeDomainAutoTunesRequest private constructor(builder: Builder) {
    /**
     * Name of the domain that you want Auto-Tune details about.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * An optional parameter that specifies the maximum number of results to return. You can use `nextToken` to get the next page of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If your initial `DescribeDomainAutoTunes` operation returns a `nextToken`, you can include the returned `nextToken` in subsequent `DescribeDomainAutoTunes` operations, which returns results in the next page.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDomainAutoTunesRequest(")
        append("domainName=$domainName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDomainAutoTunesRequest

        if (domainName != other.domainName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Name of the domain that you want Auto-Tune details about.
         */
        public var domainName: kotlin.String? = null
        /**
         * An optional parameter that specifies the maximum number of results to return. You can use `nextToken` to get the next page of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If your initial `DescribeDomainAutoTunes` operation returns a `nextToken`, you can include the returned `nextToken` in subsequent `DescribeDomainAutoTunes` operations, which returns results in the next page.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesRequest) : this() {
            this.domainName = x.domainName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesRequest = DescribeDomainAutoTunesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
