// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for request parameters to the `CreatePackage` operation.
 */
public class CreatePackageRequest private constructor(builder: Builder) {
    /**
     * The version of the Amazon OpenSearch Service engine for which is compatible with the package. This can only be specified for package type `ZIP-PLUGIN`
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The configuration parameters for the package being created.
     */
    public val packageConfiguration: aws.sdk.kotlin.services.opensearch.model.PackageConfiguration? = builder.packageConfiguration
    /**
     * Description of the package.
     */
    public val packageDescription: kotlin.String? = builder.packageDescription
    /**
     * The encryption parameters for the package being created.
     */
    public val packageEncryptionOptions: aws.sdk.kotlin.services.opensearch.model.PackageEncryptionOptions? = builder.packageEncryptionOptions
    /**
     * Unique name for the package.
     */
    public val packageName: kotlin.String? = builder.packageName
    /**
     * The Amazon S3 location from which to import the package.
     */
    public val packageSource: aws.sdk.kotlin.services.opensearch.model.PackageSource? = builder.packageSource
    /**
     * The type of package.
     */
    public val packageType: aws.sdk.kotlin.services.opensearch.model.PackageType? = builder.packageType
    /**
     * The vending options for the package being created. They determine if the package can be vended to other users.
     */
    public val packageVendingOptions: aws.sdk.kotlin.services.opensearch.model.PackageVendingOptions? = builder.packageVendingOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.CreatePackageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePackageRequest(")
        append("engineVersion=$engineVersion,")
        append("packageConfiguration=$packageConfiguration,")
        append("packageDescription=$packageDescription,")
        append("packageEncryptionOptions=$packageEncryptionOptions,")
        append("packageName=$packageName,")
        append("packageSource=$packageSource,")
        append("packageType=$packageType,")
        append("packageVendingOptions=$packageVendingOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = engineVersion?.hashCode() ?: 0
        result = 31 * result + (packageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (packageDescription?.hashCode() ?: 0)
        result = 31 * result + (packageEncryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (packageName?.hashCode() ?: 0)
        result = 31 * result + (packageSource?.hashCode() ?: 0)
        result = 31 * result + (packageType?.hashCode() ?: 0)
        result = 31 * result + (packageVendingOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePackageRequest

        if (engineVersion != other.engineVersion) return false
        if (packageConfiguration != other.packageConfiguration) return false
        if (packageDescription != other.packageDescription) return false
        if (packageEncryptionOptions != other.packageEncryptionOptions) return false
        if (packageName != other.packageName) return false
        if (packageSource != other.packageSource) return false
        if (packageType != other.packageType) return false
        if (packageVendingOptions != other.packageVendingOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.CreatePackageRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The version of the Amazon OpenSearch Service engine for which is compatible with the package. This can only be specified for package type `ZIP-PLUGIN`
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The configuration parameters for the package being created.
         */
        public var packageConfiguration: aws.sdk.kotlin.services.opensearch.model.PackageConfiguration? = null
        /**
         * Description of the package.
         */
        public var packageDescription: kotlin.String? = null
        /**
         * The encryption parameters for the package being created.
         */
        public var packageEncryptionOptions: aws.sdk.kotlin.services.opensearch.model.PackageEncryptionOptions? = null
        /**
         * Unique name for the package.
         */
        public var packageName: kotlin.String? = null
        /**
         * The Amazon S3 location from which to import the package.
         */
        public var packageSource: aws.sdk.kotlin.services.opensearch.model.PackageSource? = null
        /**
         * The type of package.
         */
        public var packageType: aws.sdk.kotlin.services.opensearch.model.PackageType? = null
        /**
         * The vending options for the package being created. They determine if the package can be vended to other users.
         */
        public var packageVendingOptions: aws.sdk.kotlin.services.opensearch.model.PackageVendingOptions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.CreatePackageRequest) : this() {
            this.engineVersion = x.engineVersion
            this.packageConfiguration = x.packageConfiguration
            this.packageDescription = x.packageDescription
            this.packageEncryptionOptions = x.packageEncryptionOptions
            this.packageName = x.packageName
            this.packageSource = x.packageSource
            this.packageType = x.packageType
            this.packageVendingOptions = x.packageVendingOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.CreatePackageRequest = CreatePackageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.PackageConfiguration] inside the given [block]
         */
        public fun packageConfiguration(block: aws.sdk.kotlin.services.opensearch.model.PackageConfiguration.Builder.() -> kotlin.Unit) {
            this.packageConfiguration = aws.sdk.kotlin.services.opensearch.model.PackageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.PackageEncryptionOptions] inside the given [block]
         */
        public fun packageEncryptionOptions(block: aws.sdk.kotlin.services.opensearch.model.PackageEncryptionOptions.Builder.() -> kotlin.Unit) {
            this.packageEncryptionOptions = aws.sdk.kotlin.services.opensearch.model.PackageEncryptionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.PackageSource] inside the given [block]
         */
        public fun packageSource(block: aws.sdk.kotlin.services.opensearch.model.PackageSource.Builder.() -> kotlin.Unit) {
            this.packageSource = aws.sdk.kotlin.services.opensearch.model.PackageSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.PackageVendingOptions] inside the given [block]
         */
        public fun packageVendingOptions(block: aws.sdk.kotlin.services.opensearch.model.PackageVendingOptions.Builder.() -> kotlin.Unit) {
            this.packageVendingOptions = aws.sdk.kotlin.services.opensearch.model.PackageVendingOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
