// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for the parameters required to enable Cognito authentication for an OpenSearch Service domain. For more information, see [Configuring Amazon Cognito authentication for OpenSearch Dashboards](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
 */
public class CognitoOptions private constructor(builder: Builder) {
    /**
     * Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
     */
    public val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * The `AmazonOpenSearchServiceCognitoAccess` role that allows OpenSearch Service to configure your user pool and identity pool.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.CognitoOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoOptions(")
        append("enabled=$enabled,")
        append("identityPoolId=$identityPoolId,")
        append("roleArn=$roleArn,")
        append("userPoolId=$userPoolId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CognitoOptions

        if (enabled != other.enabled) return false
        if (identityPoolId != other.identityPoolId) return false
        if (roleArn != other.roleArn) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.CognitoOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
         */
        public var identityPoolId: kotlin.String? = null
        /**
         * The `AmazonOpenSearchServiceCognitoAccess` role that allows OpenSearch Service to configure your user pool and identity pool.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
         */
        public var userPoolId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.CognitoOptions) : this() {
            this.enabled = x.enabled
            this.identityPoolId = x.identityPoolId
            this.roleArn = x.roleArn
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.CognitoOptions = CognitoOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
