// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The progress details of a specific domain configuration change.
 */
public class ChangeProgressStatusDetails private constructor(builder: Builder) {
    /**
     * The unique change identifier associated with a specific domain configuration change.
     */
    public val changeId: kotlin.String? = builder.changeId
    /**
     * The specific stages that the domain is going through to perform the configuration change.
     */
    public val changeProgressStages: List<ChangeProgressStage>? = builder.changeProgressStages
    /**
     * The list of properties in the domain configuration change that have completed.
     */
    public val completedProperties: List<String>? = builder.completedProperties
    /**
     * The current status of the configuration change.
     */
    public val configChangeStatus: aws.sdk.kotlin.services.opensearch.model.ConfigChangeStatus? = builder.configChangeStatus
    /**
     * The IAM principal who initiated the configuration change.
     */
    public val initiatedBy: aws.sdk.kotlin.services.opensearch.model.InitiatedBy? = builder.initiatedBy
    /**
     * The last time that the status of the configuration change was updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The list of properties in the domain configuration change that are still pending.
     */
    public val pendingProperties: List<String>? = builder.pendingProperties
    /**
     * The time at which the configuration change is made on the domain.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The overall status of the domain configuration change.
     */
    public val status: aws.sdk.kotlin.services.opensearch.model.OverallChangeStatus? = builder.status
    /**
     * The total number of stages required for the configuration change.
     */
    public val totalNumberOfStages: kotlin.Int = builder.totalNumberOfStages

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ChangeProgressStatusDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeProgressStatusDetails(")
        append("changeId=$changeId,")
        append("changeProgressStages=$changeProgressStages,")
        append("completedProperties=$completedProperties,")
        append("configChangeStatus=$configChangeStatus,")
        append("initiatedBy=$initiatedBy,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("pendingProperties=$pendingProperties,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("totalNumberOfStages=$totalNumberOfStages")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeId?.hashCode() ?: 0
        result = 31 * result + (changeProgressStages?.hashCode() ?: 0)
        result = 31 * result + (completedProperties?.hashCode() ?: 0)
        result = 31 * result + (configChangeStatus?.hashCode() ?: 0)
        result = 31 * result + (initiatedBy?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (pendingProperties?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalNumberOfStages)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeProgressStatusDetails

        if (changeId != other.changeId) return false
        if (changeProgressStages != other.changeProgressStages) return false
        if (completedProperties != other.completedProperties) return false
        if (configChangeStatus != other.configChangeStatus) return false
        if (initiatedBy != other.initiatedBy) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (pendingProperties != other.pendingProperties) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (totalNumberOfStages != other.totalNumberOfStages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ChangeProgressStatusDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique change identifier associated with a specific domain configuration change.
         */
        public var changeId: kotlin.String? = null
        /**
         * The specific stages that the domain is going through to perform the configuration change.
         */
        public var changeProgressStages: List<ChangeProgressStage>? = null
        /**
         * The list of properties in the domain configuration change that have completed.
         */
        public var completedProperties: List<String>? = null
        /**
         * The current status of the configuration change.
         */
        public var configChangeStatus: aws.sdk.kotlin.services.opensearch.model.ConfigChangeStatus? = null
        /**
         * The IAM principal who initiated the configuration change.
         */
        public var initiatedBy: aws.sdk.kotlin.services.opensearch.model.InitiatedBy? = null
        /**
         * The last time that the status of the configuration change was updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of properties in the domain configuration change that are still pending.
         */
        public var pendingProperties: List<String>? = null
        /**
         * The time at which the configuration change is made on the domain.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The overall status of the domain configuration change.
         */
        public var status: aws.sdk.kotlin.services.opensearch.model.OverallChangeStatus? = null
        /**
         * The total number of stages required for the configuration change.
         */
        public var totalNumberOfStages: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ChangeProgressStatusDetails) : this() {
            this.changeId = x.changeId
            this.changeProgressStages = x.changeProgressStages
            this.completedProperties = x.completedProperties
            this.configChangeStatus = x.configChangeStatus
            this.initiatedBy = x.initiatedBy
            this.lastUpdatedTime = x.lastUpdatedTime
            this.pendingProperties = x.pendingProperties
            this.startTime = x.startTime
            this.status = x.status
            this.totalNumberOfStages = x.totalNumberOfStages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ChangeProgressStatusDetails = ChangeProgressStatusDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
