// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about an Availability Zone on a domain.
 */
public class AvailabilityZoneInfo private constructor(builder: Builder) {
    /**
     * The name of the Availability Zone.
     */
    public val availabilityZoneName: kotlin.String? = builder.availabilityZoneName
    /**
     * The number of data nodes active in the Availability Zone.
     */
    public val availableDataNodeCount: kotlin.String? = builder.availableDataNodeCount
    /**
     * The total number of data nodes configured in the Availability Zone.
     */
    public val configuredDataNodeCount: kotlin.String? = builder.configuredDataNodeCount
    /**
     * The total number of primary and replica shards in the Availability Zone.
     */
    public val totalShards: kotlin.String? = builder.totalShards
    /**
     * The total number of primary and replica shards that aren't allocated to any of the nodes in the Availability Zone.
     */
    public val totalUnAssignedShards: kotlin.String? = builder.totalUnAssignedShards
    /**
     * The current state of the Availability Zone. Current options are `Active` and `StandBy`.
     * + `Active` - Data nodes in the Availability Zone are in use.
     * + `StandBy` - Data nodes in the Availability Zone are in a standby state.
     * + `NotAvailable` - Unable to retrieve information.
     */
    public val zoneStatus: aws.sdk.kotlin.services.opensearch.model.ZoneStatus? = builder.zoneStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.AvailabilityZoneInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AvailabilityZoneInfo(")
        append("availabilityZoneName=$availabilityZoneName,")
        append("availableDataNodeCount=$availableDataNodeCount,")
        append("configuredDataNodeCount=$configuredDataNodeCount,")
        append("totalShards=$totalShards,")
        append("totalUnAssignedShards=$totalUnAssignedShards,")
        append("zoneStatus=$zoneStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneName?.hashCode() ?: 0
        result = 31 * result + (availableDataNodeCount?.hashCode() ?: 0)
        result = 31 * result + (configuredDataNodeCount?.hashCode() ?: 0)
        result = 31 * result + (totalShards?.hashCode() ?: 0)
        result = 31 * result + (totalUnAssignedShards?.hashCode() ?: 0)
        result = 31 * result + (zoneStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AvailabilityZoneInfo

        if (availabilityZoneName != other.availabilityZoneName) return false
        if (availableDataNodeCount != other.availableDataNodeCount) return false
        if (configuredDataNodeCount != other.configuredDataNodeCount) return false
        if (totalShards != other.totalShards) return false
        if (totalUnAssignedShards != other.totalUnAssignedShards) return false
        if (zoneStatus != other.zoneStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.AvailabilityZoneInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Availability Zone.
         */
        public var availabilityZoneName: kotlin.String? = null
        /**
         * The number of data nodes active in the Availability Zone.
         */
        public var availableDataNodeCount: kotlin.String? = null
        /**
         * The total number of data nodes configured in the Availability Zone.
         */
        public var configuredDataNodeCount: kotlin.String? = null
        /**
         * The total number of primary and replica shards in the Availability Zone.
         */
        public var totalShards: kotlin.String? = null
        /**
         * The total number of primary and replica shards that aren't allocated to any of the nodes in the Availability Zone.
         */
        public var totalUnAssignedShards: kotlin.String? = null
        /**
         * The current state of the Availability Zone. Current options are `Active` and `StandBy`.
         * + `Active` - Data nodes in the Availability Zone are in use.
         * + `StandBy` - Data nodes in the Availability Zone are in a standby state.
         * + `NotAvailable` - Unable to retrieve information.
         */
        public var zoneStatus: aws.sdk.kotlin.services.opensearch.model.ZoneStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.AvailabilityZoneInfo) : this() {
            this.availabilityZoneName = x.availabilityZoneName
            this.availableDataNodeCount = x.availableDataNodeCount
            this.configuredDataNodeCount = x.configuredDataNodeCount
            this.totalShards = x.totalShards
            this.totalUnAssignedShards = x.totalUnAssignedShards
            this.zoneStatus = x.zoneStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.AvailabilityZoneInfo = AvailabilityZoneInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
