// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The current status of Auto-Tune for the domain. For more information, see [Auto-Tune for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
 */
public class AutoTuneStatus private constructor(builder: Builder) {
    /**
     * Date and time when Auto-Tune was enabled for the domain.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * Any errors that occurred while enabling or disabling Auto-Tune.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * Indicates whether the domain is being deleted.
     */
    public val pendingDeletion: kotlin.Boolean? = builder.pendingDeletion
    /**
     * The current state of Auto-Tune on the domain.
     */
    public val state: aws.sdk.kotlin.services.opensearch.model.AutoTuneState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * Date and time when the Auto-Tune options were last updated for the domain.
     */
    public val updateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateDate) { "A non-null value must be provided for updateDate" }
    /**
     * The latest version of the Auto-Tune options.
     */
    public val updateVersion: kotlin.Int = builder.updateVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.AutoTuneStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoTuneStatus(")
        append("creationDate=$creationDate,")
        append("errorMessage=$errorMessage,")
        append("pendingDeletion=$pendingDeletion,")
        append("state=$state,")
        append("updateDate=$updateDate,")
        append("updateVersion=$updateVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate.hashCode()
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (pendingDeletion?.hashCode() ?: 0)
        result = 31 * result + (state.hashCode())
        result = 31 * result + (updateDate.hashCode())
        result = 31 * result + (updateVersion)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoTuneStatus

        if (creationDate != other.creationDate) return false
        if (errorMessage != other.errorMessage) return false
        if (pendingDeletion != other.pendingDeletion) return false
        if (state != other.state) return false
        if (updateDate != other.updateDate) return false
        if (updateVersion != other.updateVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.AutoTuneStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Date and time when Auto-Tune was enabled for the domain.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Any errors that occurred while enabling or disabling Auto-Tune.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * Indicates whether the domain is being deleted.
         */
        public var pendingDeletion: kotlin.Boolean? = null
        /**
         * The current state of Auto-Tune on the domain.
         */
        public var state: aws.sdk.kotlin.services.opensearch.model.AutoTuneState? = null
        /**
         * Date and time when the Auto-Tune options were last updated for the domain.
         */
        public var updateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The latest version of the Auto-Tune options.
         */
        public var updateVersion: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.AutoTuneStatus) : this() {
            this.creationDate = x.creationDate
            this.errorMessage = x.errorMessage
            this.pendingDeletion = x.pendingDeletion
            this.state = x.state
            this.updateDate = x.updateDate
            this.updateVersion = x.updateVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.AutoTuneStatus = AutoTuneStatus(this)

        internal fun correctErrors(): Builder {
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (state == null) state = AutoTuneState.SdkUnknown("no value provided")
            if (updateDate == null) updateDate = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
