// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Auto-Tune settings when updating a domain. For more information, see [Auto-Tune for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
 */
public class AutoTuneOptions private constructor(builder: Builder) {
    /**
     * Whether Auto-Tune is enabled or disabled.
     */
    public val desiredState: aws.sdk.kotlin.services.opensearch.model.AutoTuneDesiredState? = builder.desiredState
    /**
     * DEPRECATED. Use [off-peak window](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html) instead.
     *
     * A list of maintenance schedules during which Auto-Tune can deploy changes.
     */
    public val maintenanceSchedules: List<AutoTuneMaintenanceSchedule>? = builder.maintenanceSchedules
    /**
     * When disabling Auto-Tune, specify `NO_ROLLBACK` to retain all prior Auto-Tune settings or `DEFAULT_ROLLBACK` to revert to the OpenSearch Service defaults. If you specify `DEFAULT_ROLLBACK`, you must include a `MaintenanceSchedule` in the request. Otherwise, OpenSearch Service is unable to perform the rollback.
     */
    public val rollbackOnDisable: aws.sdk.kotlin.services.opensearch.model.RollbackOnDisable? = builder.rollbackOnDisable
    /**
     * Whether to use the domain's [off-peak window](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html) to deploy configuration changes on the domain rather than a maintenance schedule.
     */
    public val useOffPeakWindow: kotlin.Boolean? = builder.useOffPeakWindow

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoTuneOptions(")
        append("desiredState=$desiredState,")
        append("maintenanceSchedules=$maintenanceSchedules,")
        append("rollbackOnDisable=$rollbackOnDisable,")
        append("useOffPeakWindow=$useOffPeakWindow")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredState?.hashCode() ?: 0
        result = 31 * result + (maintenanceSchedules?.hashCode() ?: 0)
        result = 31 * result + (rollbackOnDisable?.hashCode() ?: 0)
        result = 31 * result + (useOffPeakWindow?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoTuneOptions

        if (desiredState != other.desiredState) return false
        if (maintenanceSchedules != other.maintenanceSchedules) return false
        if (rollbackOnDisable != other.rollbackOnDisable) return false
        if (useOffPeakWindow != other.useOffPeakWindow) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether Auto-Tune is enabled or disabled.
         */
        public var desiredState: aws.sdk.kotlin.services.opensearch.model.AutoTuneDesiredState? = null
        /**
         * DEPRECATED. Use [off-peak window](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html) instead.
         *
         * A list of maintenance schedules during which Auto-Tune can deploy changes.
         */
        public var maintenanceSchedules: List<AutoTuneMaintenanceSchedule>? = null
        /**
         * When disabling Auto-Tune, specify `NO_ROLLBACK` to retain all prior Auto-Tune settings or `DEFAULT_ROLLBACK` to revert to the OpenSearch Service defaults. If you specify `DEFAULT_ROLLBACK`, you must include a `MaintenanceSchedule` in the request. Otherwise, OpenSearch Service is unable to perform the rollback.
         */
        public var rollbackOnDisable: aws.sdk.kotlin.services.opensearch.model.RollbackOnDisable? = null
        /**
         * Whether to use the domain's [off-peak window](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html) to deploy configuration changes on the domain rather than a maintenance schedule.
         */
        public var useOffPeakWindow: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions) : this() {
            this.desiredState = x.desiredState
            this.maintenanceSchedules = x.maintenanceSchedules
            this.rollbackOnDisable = x.rollbackOnDisable
            this.useOffPeakWindow = x.useOffPeakWindow
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions = AutoTuneOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
