// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Container for the request parameters to the `AssociatePackage` operation.
 */
public class AssociatePackageRequest private constructor(builder: Builder) {
    /**
     * The configuration for associating a package with an Amazon OpenSearch Service domain.
     */
    public val associationConfiguration: aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration? = builder.associationConfiguration
    /**
     * Name of the domain to associate the package with.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * Internal ID of the package to associate with a domain. Use `DescribePackages` to find this value.
     */
    public val packageId: kotlin.String? = builder.packageId
    /**
     * A list of package IDs that must be associated with the domain before the package specified in the request can be associated.
     */
    public val prerequisitePackageIdList: List<String>? = builder.prerequisitePackageIdList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.AssociatePackageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociatePackageRequest(")
        append("associationConfiguration=$associationConfiguration,")
        append("domainName=$domainName,")
        append("packageId=$packageId,")
        append("prerequisitePackageIdList=$prerequisitePackageIdList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationConfiguration?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (packageId?.hashCode() ?: 0)
        result = 31 * result + (prerequisitePackageIdList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociatePackageRequest

        if (associationConfiguration != other.associationConfiguration) return false
        if (domainName != other.domainName) return false
        if (packageId != other.packageId) return false
        if (prerequisitePackageIdList != other.prerequisitePackageIdList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.AssociatePackageRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for associating a package with an Amazon OpenSearch Service domain.
         */
        public var associationConfiguration: aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration? = null
        /**
         * Name of the domain to associate the package with.
         */
        public var domainName: kotlin.String? = null
        /**
         * Internal ID of the package to associate with a domain. Use `DescribePackages` to find this value.
         */
        public var packageId: kotlin.String? = null
        /**
         * A list of package IDs that must be associated with the domain before the package specified in the request can be associated.
         */
        public var prerequisitePackageIdList: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.AssociatePackageRequest) : this() {
            this.associationConfiguration = x.associationConfiguration
            this.domainName = x.domainName
            this.packageId = x.packageId
            this.prerequisitePackageIdList = x.prerequisitePackageIdList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.AssociatePackageRequest = AssociatePackageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration] inside the given [block]
         */
        public fun associationConfiguration(block: aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration.Builder.() -> kotlin.Unit) {
            this.associationConfiguration = aws.sdk.kotlin.services.opensearch.model.PackageAssociationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
