// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Options for enabling and configuring fine-grained access control. For more information, see [Fine-grained access control in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html).
 */
public class AdvancedSecurityOptionsInput private constructor(builder: Builder) {
    /**
     * True to enable a 30-day migration period during which administrators can create role mappings. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing).
     */
    public val anonymousAuthEnabled: kotlin.Boolean? = builder.anonymousAuthEnabled
    /**
     * True to enable fine-grained access control.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Container for information about the IAM federation configuration for an OpenSearch UI application.
     */
    public val iamFederationOptions: aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsInput? = builder.iamFederationOptions
    /**
     * True to enable the internal user database.
     */
    public val internalUserDatabaseEnabled: kotlin.Boolean? = builder.internalUserDatabaseEnabled
    /**
     * Container for information about the JWT configuration of the Amazon OpenSearch Service.
     */
    public val jwtOptions: aws.sdk.kotlin.services.opensearch.model.JwtOptionsInput? = builder.jwtOptions
    /**
     * Container for information about the master user.
     */
    public val masterUserOptions: aws.sdk.kotlin.services.opensearch.model.MasterUserOptions? = builder.masterUserOptions
    /**
     * Container for information about the SAML configuration for OpenSearch Dashboards.
     */
    public val samlOptions: aws.sdk.kotlin.services.opensearch.model.SamlOptionsInput? = builder.samlOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedSecurityOptionsInput(")
        append("anonymousAuthEnabled=$anonymousAuthEnabled,")
        append("enabled=$enabled,")
        append("iamFederationOptions=$iamFederationOptions,")
        append("internalUserDatabaseEnabled=$internalUserDatabaseEnabled,")
        append("jwtOptions=$jwtOptions,")
        append("masterUserOptions=$masterUserOptions,")
        append("samlOptions=$samlOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anonymousAuthEnabled?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (iamFederationOptions?.hashCode() ?: 0)
        result = 31 * result + (internalUserDatabaseEnabled?.hashCode() ?: 0)
        result = 31 * result + (jwtOptions?.hashCode() ?: 0)
        result = 31 * result + (masterUserOptions?.hashCode() ?: 0)
        result = 31 * result + (samlOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedSecurityOptionsInput

        if (anonymousAuthEnabled != other.anonymousAuthEnabled) return false
        if (enabled != other.enabled) return false
        if (iamFederationOptions != other.iamFederationOptions) return false
        if (internalUserDatabaseEnabled != other.internalUserDatabaseEnabled) return false
        if (jwtOptions != other.jwtOptions) return false
        if (masterUserOptions != other.masterUserOptions) return false
        if (samlOptions != other.samlOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * True to enable a 30-day migration period during which administrators can create role mappings. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing).
         */
        public var anonymousAuthEnabled: kotlin.Boolean? = null
        /**
         * True to enable fine-grained access control.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Container for information about the IAM federation configuration for an OpenSearch UI application.
         */
        public var iamFederationOptions: aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsInput? = null
        /**
         * True to enable the internal user database.
         */
        public var internalUserDatabaseEnabled: kotlin.Boolean? = null
        /**
         * Container for information about the JWT configuration of the Amazon OpenSearch Service.
         */
        public var jwtOptions: aws.sdk.kotlin.services.opensearch.model.JwtOptionsInput? = null
        /**
         * Container for information about the master user.
         */
        public var masterUserOptions: aws.sdk.kotlin.services.opensearch.model.MasterUserOptions? = null
        /**
         * Container for information about the SAML configuration for OpenSearch Dashboards.
         */
        public var samlOptions: aws.sdk.kotlin.services.opensearch.model.SamlOptionsInput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput) : this() {
            this.anonymousAuthEnabled = x.anonymousAuthEnabled
            this.enabled = x.enabled
            this.iamFederationOptions = x.iamFederationOptions
            this.internalUserDatabaseEnabled = x.internalUserDatabaseEnabled
            this.jwtOptions = x.jwtOptions
            this.masterUserOptions = x.masterUserOptions
            this.samlOptions = x.samlOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput = AdvancedSecurityOptionsInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsInput] inside the given [block]
         */
        public fun iamFederationOptions(block: aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsInput.Builder.() -> kotlin.Unit) {
            this.iamFederationOptions = aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.JwtOptionsInput] inside the given [block]
         */
        public fun jwtOptions(block: aws.sdk.kotlin.services.opensearch.model.JwtOptionsInput.Builder.() -> kotlin.Unit) {
            this.jwtOptions = aws.sdk.kotlin.services.opensearch.model.JwtOptionsInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.MasterUserOptions] inside the given [block]
         */
        public fun masterUserOptions(block: aws.sdk.kotlin.services.opensearch.model.MasterUserOptions.Builder.() -> kotlin.Unit) {
            this.masterUserOptions = aws.sdk.kotlin.services.opensearch.model.MasterUserOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.SamlOptionsInput] inside the given [block]
         */
        public fun samlOptions(block: aws.sdk.kotlin.services.opensearch.model.SamlOptionsInput.Builder.() -> kotlin.Unit) {
            this.samlOptions = aws.sdk.kotlin.services.opensearch.model.SamlOptionsInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
