// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Container for fine-grained access control settings.
 */
public class AdvancedSecurityOptions private constructor(builder: Builder) {
    /**
     * Date and time when the migration period will be disabled. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing).
     */
    public val anonymousAuthDisableDate: aws.smithy.kotlin.runtime.time.Instant? = builder.anonymousAuthDisableDate
    /**
     * True if a 30-day migration period is enabled, during which administrators can create role mappings. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing).
     */
    public val anonymousAuthEnabled: kotlin.Boolean? = builder.anonymousAuthEnabled
    /**
     * True if fine-grained access control is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Container for information about the IAM federation configuration for an OpenSearch UI application.
     */
    public val iamFederationOptions: aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsOutput? = builder.iamFederationOptions
    /**
     * True if the internal user database is enabled.
     */
    public val internalUserDatabaseEnabled: kotlin.Boolean? = builder.internalUserDatabaseEnabled
    /**
     * Container for information about the JWT configuration of the Amazon OpenSearch Service.
     */
    public val jwtOptions: aws.sdk.kotlin.services.opensearch.model.JwtOptionsOutput? = builder.jwtOptions
    /**
     * Container for information about the SAML configuration for OpenSearch Dashboards.
     */
    public val samlOptions: aws.sdk.kotlin.services.opensearch.model.SamlOptionsOutput? = builder.samlOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedSecurityOptions(")
        append("anonymousAuthDisableDate=$anonymousAuthDisableDate,")
        append("anonymousAuthEnabled=$anonymousAuthEnabled,")
        append("enabled=$enabled,")
        append("iamFederationOptions=$iamFederationOptions,")
        append("internalUserDatabaseEnabled=$internalUserDatabaseEnabled,")
        append("jwtOptions=$jwtOptions,")
        append("samlOptions=$samlOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anonymousAuthDisableDate?.hashCode() ?: 0
        result = 31 * result + (anonymousAuthEnabled?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (iamFederationOptions?.hashCode() ?: 0)
        result = 31 * result + (internalUserDatabaseEnabled?.hashCode() ?: 0)
        result = 31 * result + (jwtOptions?.hashCode() ?: 0)
        result = 31 * result + (samlOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedSecurityOptions

        if (anonymousAuthDisableDate != other.anonymousAuthDisableDate) return false
        if (anonymousAuthEnabled != other.anonymousAuthEnabled) return false
        if (enabled != other.enabled) return false
        if (iamFederationOptions != other.iamFederationOptions) return false
        if (internalUserDatabaseEnabled != other.internalUserDatabaseEnabled) return false
        if (jwtOptions != other.jwtOptions) return false
        if (samlOptions != other.samlOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Date and time when the migration period will be disabled. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing).
         */
        public var anonymousAuthDisableDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * True if a 30-day migration period is enabled, during which administrators can create role mappings. Only necessary when [enabling fine-grained access control on an existing domain](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing).
         */
        public var anonymousAuthEnabled: kotlin.Boolean? = null
        /**
         * True if fine-grained access control is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Container for information about the IAM federation configuration for an OpenSearch UI application.
         */
        public var iamFederationOptions: aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsOutput? = null
        /**
         * True if the internal user database is enabled.
         */
        public var internalUserDatabaseEnabled: kotlin.Boolean? = null
        /**
         * Container for information about the JWT configuration of the Amazon OpenSearch Service.
         */
        public var jwtOptions: aws.sdk.kotlin.services.opensearch.model.JwtOptionsOutput? = null
        /**
         * Container for information about the SAML configuration for OpenSearch Dashboards.
         */
        public var samlOptions: aws.sdk.kotlin.services.opensearch.model.SamlOptionsOutput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptions) : this() {
            this.anonymousAuthDisableDate = x.anonymousAuthDisableDate
            this.anonymousAuthEnabled = x.anonymousAuthEnabled
            this.enabled = x.enabled
            this.iamFederationOptions = x.iamFederationOptions
            this.internalUserDatabaseEnabled = x.internalUserDatabaseEnabled
            this.jwtOptions = x.jwtOptions
            this.samlOptions = x.samlOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptions = AdvancedSecurityOptions(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsOutput] inside the given [block]
         */
        public fun iamFederationOptions(block: aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsOutput.Builder.() -> kotlin.Unit) {
            this.iamFederationOptions = aws.sdk.kotlin.services.opensearch.model.IamFederationOptionsOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.JwtOptionsOutput] inside the given [block]
         */
        public fun jwtOptions(block: aws.sdk.kotlin.services.opensearch.model.JwtOptionsOutput.Builder.() -> kotlin.Unit) {
            this.jwtOptions = aws.sdk.kotlin.services.opensearch.model.JwtOptionsOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.SamlOptionsOutput] inside the given [block]
         */
        public fun samlOptions(block: aws.sdk.kotlin.services.opensearch.model.SamlOptionsOutput.Builder.() -> kotlin.Unit) {
            this.samlOptions = aws.sdk.kotlin.services.opensearch.model.SamlOptionsOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
