// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.oam.paginators

import aws.sdk.kotlin.services.oam.OamClient
import aws.sdk.kotlin.services.oam.model.ListAttachedLinksItem
import aws.sdk.kotlin.services.oam.model.ListAttachedLinksRequest
import aws.sdk.kotlin.services.oam.model.ListAttachedLinksResponse
import aws.sdk.kotlin.services.oam.model.ListLinksItem
import aws.sdk.kotlin.services.oam.model.ListLinksRequest
import aws.sdk.kotlin.services.oam.model.ListLinksResponse
import aws.sdk.kotlin.services.oam.model.ListSinksItem
import aws.sdk.kotlin.services.oam.model.ListSinksRequest
import aws.sdk.kotlin.services.oam.model.ListSinksResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAttachedLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAttachedLinksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachedLinksResponse]
 */
public fun OamClient.listAttachedLinksPaginated(initialRequest: ListAttachedLinksRequest): Flow<ListAttachedLinksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAttachedLinksPaginated.listAttachedLinks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAttachedLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachedLinksResponse]
 */
public fun OamClient.listAttachedLinksPaginated(block: ListAttachedLinksRequest.Builder.() -> Unit): Flow<ListAttachedLinksResponse> =
    listAttachedLinksPaginated(ListAttachedLinksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAttachedLinksPaginated]
 * to access the nested member [ListAttachedLinksItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachedLinksItem]
 */
@JvmName("listAttachedLinksResponseListAttachedLinksItem")
public fun Flow<ListAttachedLinksResponse>.items(): Flow<ListAttachedLinksItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLinksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLinksResponse]
 */
public fun OamClient.listLinksPaginated(initialRequest: ListLinksRequest = ListLinksRequest { }): Flow<ListLinksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLinksPaginated.listLinks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLinksResponse]
 */
public fun OamClient.listLinksPaginated(block: ListLinksRequest.Builder.() -> Unit): Flow<ListLinksResponse> =
    listLinksPaginated(ListLinksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLinksPaginated]
 * to access the nested member [ListLinksItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLinksItem]
 */
@JvmName("listLinksResponseListLinksItem")
public fun Flow<ListLinksResponse>.items(): Flow<ListLinksItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSinksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSinksResponse]
 */
public fun OamClient.listSinksPaginated(initialRequest: ListSinksRequest = ListSinksRequest { }): Flow<ListSinksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSinksPaginated.listSinks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSinksResponse]
 */
public fun OamClient.listSinksPaginated(block: ListSinksRequest.Builder.() -> Unit): Flow<ListSinksResponse> =
    listSinksPaginated(ListSinksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSinksPaginated]
 * to access the nested member [ListSinksItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSinksItem]
 */
@JvmName("listSinksResponseListSinksItem")
public fun Flow<ListSinksResponse>.items(): Flow<ListSinksItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
