// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.oam.model



public class CreateLinkRequest private constructor(builder: Builder) {
    /**
     * Specify a friendly human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
     *
     * You can use a custom label or use the following variables:
     * + `$AccountName` is the name of the account
     * + `$AccountEmail` is the globally unique email address of the account
     * + `$AccountEmailNoDomain` is the email address of the account without the domain name
     */
    public val labelTemplate: kotlin.String? = builder.labelTemplate
    /**
     * An array of strings that define which types of data that the source account shares with the monitoring account.
     */
    public val resourceTypes: List<ResourceType>? = builder.resourceTypes
    /**
     * The ARN of the sink to use to create this link. You can use [ListSinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html) to find the ARNs of sinks.
     *
     * For more information about sinks, see [CreateSink](https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html).
     */
    public val sinkIdentifier: kotlin.String? = builder.sinkIdentifier
    /**
     * Assigns one or more tags (key-value pairs) to the link.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     *
     * For more information about using tags to control access, see [Controlling access to Amazon Web Services resources using tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.oam.model.CreateLinkRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLinkRequest(")
        append("labelTemplate=$labelTemplate,")
        append("resourceTypes=$resourceTypes,")
        append("sinkIdentifier=$sinkIdentifier,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = labelTemplate?.hashCode() ?: 0
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (sinkIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLinkRequest

        if (labelTemplate != other.labelTemplate) return false
        if (resourceTypes != other.resourceTypes) return false
        if (sinkIdentifier != other.sinkIdentifier) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.oam.model.CreateLinkRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify a friendly human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
         *
         * You can use a custom label or use the following variables:
         * + `$AccountName` is the name of the account
         * + `$AccountEmail` is the globally unique email address of the account
         * + `$AccountEmailNoDomain` is the email address of the account without the domain name
         */
        public var labelTemplate: kotlin.String? = null
        /**
         * An array of strings that define which types of data that the source account shares with the monitoring account.
         */
        public var resourceTypes: List<ResourceType>? = null
        /**
         * The ARN of the sink to use to create this link. You can use [ListSinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html) to find the ARNs of sinks.
         *
         * For more information about sinks, see [CreateSink](https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html).
         */
        public var sinkIdentifier: kotlin.String? = null
        /**
         * Assigns one or more tags (key-value pairs) to the link.
         *
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         *
         * For more information about using tags to control access, see [Controlling access to Amazon Web Services resources using tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.oam.model.CreateLinkRequest) : this() {
            this.labelTemplate = x.labelTemplate
            this.resourceTypes = x.resourceTypes
            this.sinkIdentifier = x.sinkIdentifier
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.oam.model.CreateLinkRequest = CreateLinkRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
