// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.oam.endpoints.internal

import aws.sdk.kotlin.services.oam.OamClient
import aws.sdk.kotlin.services.oam.endpoints.OamEndpointParameters
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.collections.get
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest

internal class EndpointResolverAdapter(
    private val config: OamClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        return endpoint
    }
}

internal fun resolveEndpointParams(config: OamClient.Config, request: ResolveEndpointRequest): OamEndpointParameters {
    return OamEndpointParameters {
        region = config.region
        bindAwsBuiltins(config, request)
        endpoint = config.endpointUrl?.toString()
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (OamEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
)

private fun OamEndpointParameters.Builder.bindAwsBuiltins(config: OamClient.Config, request: ResolveEndpointRequest) {
    useDualStack = config.useDualStack
    useFips = config.useFips
}
