// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.oam

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.oam.auth.DefaultOamAuthSchemeProvider
import aws.sdk.kotlin.services.oam.auth.OamAuthSchemeProvider
import aws.sdk.kotlin.services.oam.endpoints.DefaultOamEndpointProvider
import aws.sdk.kotlin.services.oam.endpoints.OamEndpointParameters
import aws.sdk.kotlin.services.oam.endpoints.OamEndpointProvider
import aws.sdk.kotlin.services.oam.model.CreateLinkRequest
import aws.sdk.kotlin.services.oam.model.CreateLinkResponse
import aws.sdk.kotlin.services.oam.model.CreateSinkRequest
import aws.sdk.kotlin.services.oam.model.CreateSinkResponse
import aws.sdk.kotlin.services.oam.model.DeleteLinkRequest
import aws.sdk.kotlin.services.oam.model.DeleteLinkResponse
import aws.sdk.kotlin.services.oam.model.DeleteSinkRequest
import aws.sdk.kotlin.services.oam.model.DeleteSinkResponse
import aws.sdk.kotlin.services.oam.model.GetLinkRequest
import aws.sdk.kotlin.services.oam.model.GetLinkResponse
import aws.sdk.kotlin.services.oam.model.GetSinkPolicyRequest
import aws.sdk.kotlin.services.oam.model.GetSinkPolicyResponse
import aws.sdk.kotlin.services.oam.model.GetSinkRequest
import aws.sdk.kotlin.services.oam.model.GetSinkResponse
import aws.sdk.kotlin.services.oam.model.ListAttachedLinksRequest
import aws.sdk.kotlin.services.oam.model.ListAttachedLinksResponse
import aws.sdk.kotlin.services.oam.model.ListLinksRequest
import aws.sdk.kotlin.services.oam.model.ListLinksResponse
import aws.sdk.kotlin.services.oam.model.ListSinksRequest
import aws.sdk.kotlin.services.oam.model.ListSinksResponse
import aws.sdk.kotlin.services.oam.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.oam.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.oam.model.PutSinkPolicyRequest
import aws.sdk.kotlin.services.oam.model.PutSinkPolicyResponse
import aws.sdk.kotlin.services.oam.model.TagResourceRequest
import aws.sdk.kotlin.services.oam.model.TagResourceResponse
import aws.sdk.kotlin.services.oam.model.UntagResourceRequest
import aws.sdk.kotlin.services.oam.model.UntagResourceResponse
import aws.sdk.kotlin.services.oam.model.UpdateLinkRequest
import aws.sdk.kotlin.services.oam.model.UpdateLinkResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "OAM"
public const val SdkVersion: String = "1.1.1"
public const val ServiceApiVersion: String = "2022-06-10"

/**
 * Use Amazon CloudWatch Observability Access Manager to create and manage links between source accounts and monitoring accounts by using *CloudWatch cross-account observability*. With CloudWatch cross-account observability, you can monitor and troubleshoot applications that span multiple accounts within a Region. Seamlessly search, visualize, and analyze your metrics, logs, traces, and Application Insights applications in any of the linked accounts without account boundaries.
 *
 * Set up one or more Amazon Web Services accounts as *monitoring accounts* and link them with multiple *source accounts*. A monitoring account is a central Amazon Web Services account that can view and interact with observability data generated from source accounts. A source account is an individual Amazon Web Services account that generates observability data for the resources that reside in it. Source accounts share their observability data with the monitoring account. The shared observability data can include metrics in Amazon CloudWatch, logs in Amazon CloudWatch Logs, traces in X-Ray, and applications in Amazon CloudWatch Application Insights.
 */
public interface OamClient : SdkClient {
    /**
     * OamClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, OamClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Oam",
                "OAM",
                "oam",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, OamClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): OamClient = DefaultOamClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: OamEndpointProvider = builder.endpointProvider ?: DefaultOamEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: OamAuthSchemeProvider = builder.authSchemeProvider ?: DefaultOamAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "OAM"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: OamEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: OamAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a link between a source account and a sink that you have created in a monitoring account.
     *
     * Before you create a link, you must create a sink in the monitoring account and create a sink policy in that account. The sink policy must permit the source account to link to it. You can grant permission to source accounts by granting permission to an entire organization or to individual accounts.
     *
     * For more information, see [CreateSink](https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html) and [PutSinkPolicy](https://docs.aws.amazon.com/OAM/latest/APIReference/API_PutSinkPolicy.html).
     *
     * Each monitoring account can be linked to as many as 100,000 source accounts.
     *
     * Each source account can be linked to as many as five monitoring accounts.
     */
    public suspend fun createLink(input: CreateLinkRequest): CreateLinkResponse

    /**
     * Use this to create a *sink* in the current account, so that it can be used as a monitoring account in CloudWatch cross-account observability. A sink is a resource that represents an attachment point in a monitoring account. Source accounts can link to the sink to send observability data.
     *
     * After you create a sink, you must create a sink policy that allows source accounts to attach to it. For more information, see [PutSinkPolicy](https://docs.aws.amazon.com/OAM/latest/APIReference/API_PutSinkPolicy.html).
     *
     * Each account can contain one sink. If you delete a sink, you can then create a new one in that account.
     */
    public suspend fun createSink(input: CreateSinkRequest): CreateSinkResponse

    /**
     * Deletes a link between a monitoring account sink and a source account. You must run this operation in the source account.
     */
    public suspend fun deleteLink(input: DeleteLinkRequest): DeleteLinkResponse

    /**
     * Deletes a sink. You must delete all links to a sink before you can delete that sink.
     */
    public suspend fun deleteSink(input: DeleteSinkRequest): DeleteSinkResponse

    /**
     * Returns complete information about one link.
     *
     * To use this operation, provide the link ARN. To retrieve a list of link ARNs, use [ListLinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListLinks.html).
     */
    public suspend fun getLink(input: GetLinkRequest): GetLinkResponse

    /**
     * Returns complete information about one monitoring account sink.
     *
     * To use this operation, provide the sink ARN. To retrieve a list of sink ARNs, use [ListSinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html).
     */
    public suspend fun getSink(input: GetSinkRequest): GetSinkResponse

    /**
     * Returns the current sink policy attached to this sink. The sink policy specifies what accounts can attach to this sink as source accounts, and what types of data they can share.
     */
    public suspend fun getSinkPolicy(input: GetSinkPolicyRequest): GetSinkPolicyResponse

    /**
     * Returns a list of source account links that are linked to this monitoring account sink.
     *
     * To use this operation, provide the sink ARN. To retrieve a list of sink ARNs, use [ListSinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html).
     *
     * To find a list of links for one source account, use [ListLinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListLinks.html).
     */
    public suspend fun listAttachedLinks(input: ListAttachedLinksRequest): ListAttachedLinksResponse

    /**
     * Use this operation in a source account to return a list of links to monitoring account sinks that this source account has.
     *
     * To find a list of links for one monitoring account sink, use [ListAttachedLinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListAttachedLinks.html) from within the monitoring account.
     */
    public suspend fun listLinks(input: ListLinksRequest = ListLinksRequest { }): ListLinksResponse

    /**
     * Use this operation in a monitoring account to return the list of sinks created in that account.
     */
    public suspend fun listSinks(input: ListSinksRequest = ListSinksRequest { }): ListSinksResponse

    /**
     * Displays the tags associated with a resource. Both sinks and links support tagging.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates the resource policy that grants permissions to source accounts to link to the monitoring account sink. When you create a sink policy, you can grant permissions to all accounts in an organization or to individual accounts.
     *
     * You can also use a sink policy to limit the types of data that is shared. The three types that you can allow or deny are:
     * + **Metrics** - Specify with `AWS::CloudWatch::Metric`
     * + **Log groups** - Specify with `AWS::Logs::LogGroup`
     * + **Traces** - Specify with `AWS::XRay::Trace`
     * + **Application Insights - Applications** - Specify with `AWS::ApplicationInsights::Application`
     *
     * See the examples in this section to see how to specify permitted source accounts and data types.
     */
    public suspend fun putSinkPolicy(input: PutSinkPolicyRequest): PutSinkPolicyResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified resource. Both sinks and links can be tagged.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     *
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
     *
     * You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the alarm, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a resource.
     *
     * Unlike tagging permissions in other Amazon Web Services services, to tag or untag links and sinks you must have the `oam:ResourceTag` permission. The `iam:ResourceTag` permission does not allow you to tag and untag links and sinks.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     *
     * Unlike tagging permissions in other Amazon Web Services services, to tag or untag links and sinks you must have the `oam:ResourceTag` permission. The `iam:TagResource` permission does not allow you to tag and untag links and sinks.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Use this operation to change what types of data are shared from a source account to its linked monitoring account sink. You can't change the sink or change the monitoring account with this operation.
     *
     * To update the list of tags associated with the sink, use [TagResource](https://docs.aws.amazon.com/OAM/latest/APIReference/API_TagResource.html).
     */
    public suspend fun updateLink(input: UpdateLinkRequest): UpdateLinkResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun OamClient.withConfig(block: OamClient.Config.Builder.() -> Unit): OamClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultOamClient(newConfig)
}

/**
 * Creates a link between a source account and a sink that you have created in a monitoring account.
 *
 * Before you create a link, you must create a sink in the monitoring account and create a sink policy in that account. The sink policy must permit the source account to link to it. You can grant permission to source accounts by granting permission to an entire organization or to individual accounts.
 *
 * For more information, see [CreateSink](https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html) and [PutSinkPolicy](https://docs.aws.amazon.com/OAM/latest/APIReference/API_PutSinkPolicy.html).
 *
 * Each monitoring account can be linked to as many as 100,000 source accounts.
 *
 * Each source account can be linked to as many as five monitoring accounts.
 */
public suspend inline fun OamClient.createLink(crossinline block: CreateLinkRequest.Builder.() -> Unit): CreateLinkResponse = createLink(CreateLinkRequest.Builder().apply(block).build())

/**
 * Use this to create a *sink* in the current account, so that it can be used as a monitoring account in CloudWatch cross-account observability. A sink is a resource that represents an attachment point in a monitoring account. Source accounts can link to the sink to send observability data.
 *
 * After you create a sink, you must create a sink policy that allows source accounts to attach to it. For more information, see [PutSinkPolicy](https://docs.aws.amazon.com/OAM/latest/APIReference/API_PutSinkPolicy.html).
 *
 * Each account can contain one sink. If you delete a sink, you can then create a new one in that account.
 */
public suspend inline fun OamClient.createSink(crossinline block: CreateSinkRequest.Builder.() -> Unit): CreateSinkResponse = createSink(CreateSinkRequest.Builder().apply(block).build())

/**
 * Deletes a link between a monitoring account sink and a source account. You must run this operation in the source account.
 */
public suspend inline fun OamClient.deleteLink(crossinline block: DeleteLinkRequest.Builder.() -> Unit): DeleteLinkResponse = deleteLink(DeleteLinkRequest.Builder().apply(block).build())

/**
 * Deletes a sink. You must delete all links to a sink before you can delete that sink.
 */
public suspend inline fun OamClient.deleteSink(crossinline block: DeleteSinkRequest.Builder.() -> Unit): DeleteSinkResponse = deleteSink(DeleteSinkRequest.Builder().apply(block).build())

/**
 * Returns complete information about one link.
 *
 * To use this operation, provide the link ARN. To retrieve a list of link ARNs, use [ListLinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListLinks.html).
 */
public suspend inline fun OamClient.getLink(crossinline block: GetLinkRequest.Builder.() -> Unit): GetLinkResponse = getLink(GetLinkRequest.Builder().apply(block).build())

/**
 * Returns complete information about one monitoring account sink.
 *
 * To use this operation, provide the sink ARN. To retrieve a list of sink ARNs, use [ListSinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html).
 */
public suspend inline fun OamClient.getSink(crossinline block: GetSinkRequest.Builder.() -> Unit): GetSinkResponse = getSink(GetSinkRequest.Builder().apply(block).build())

/**
 * Returns the current sink policy attached to this sink. The sink policy specifies what accounts can attach to this sink as source accounts, and what types of data they can share.
 */
public suspend inline fun OamClient.getSinkPolicy(crossinline block: GetSinkPolicyRequest.Builder.() -> Unit): GetSinkPolicyResponse = getSinkPolicy(GetSinkPolicyRequest.Builder().apply(block).build())

/**
 * Returns a list of source account links that are linked to this monitoring account sink.
 *
 * To use this operation, provide the sink ARN. To retrieve a list of sink ARNs, use [ListSinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html).
 *
 * To find a list of links for one source account, use [ListLinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListLinks.html).
 */
public suspend inline fun OamClient.listAttachedLinks(crossinline block: ListAttachedLinksRequest.Builder.() -> Unit): ListAttachedLinksResponse = listAttachedLinks(ListAttachedLinksRequest.Builder().apply(block).build())

/**
 * Use this operation in a source account to return a list of links to monitoring account sinks that this source account has.
 *
 * To find a list of links for one monitoring account sink, use [ListAttachedLinks](https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListAttachedLinks.html) from within the monitoring account.
 */
public suspend inline fun OamClient.listLinks(crossinline block: ListLinksRequest.Builder.() -> Unit): ListLinksResponse = listLinks(ListLinksRequest.Builder().apply(block).build())

/**
 * Use this operation in a monitoring account to return the list of sinks created in that account.
 */
public suspend inline fun OamClient.listSinks(crossinline block: ListSinksRequest.Builder.() -> Unit): ListSinksResponse = listSinks(ListSinksRequest.Builder().apply(block).build())

/**
 * Displays the tags associated with a resource. Both sinks and links support tagging.
 */
public suspend inline fun OamClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates the resource policy that grants permissions to source accounts to link to the monitoring account sink. When you create a sink policy, you can grant permissions to all accounts in an organization or to individual accounts.
 *
 * You can also use a sink policy to limit the types of data that is shared. The three types that you can allow or deny are:
 * + **Metrics** - Specify with `AWS::CloudWatch::Metric`
 * + **Log groups** - Specify with `AWS::Logs::LogGroup`
 * + **Traces** - Specify with `AWS::XRay::Trace`
 * + **Application Insights - Applications** - Specify with `AWS::ApplicationInsights::Application`
 *
 * See the examples in this section to see how to specify permitted source accounts and data types.
 */
public suspend inline fun OamClient.putSinkPolicy(crossinline block: PutSinkPolicyRequest.Builder.() -> Unit): PutSinkPolicyResponse = putSinkPolicy(PutSinkPolicyRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified resource. Both sinks and links can be tagged.
 *
 * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
 *
 * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
 *
 * You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the alarm, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate as many as 50 tags with a resource.
 *
 * Unlike tagging permissions in other Amazon Web Services services, to tag or untag links and sinks you must have the `oam:ResourceTag` permission. The `iam:ResourceTag` permission does not allow you to tag and untag links and sinks.
 */
public suspend inline fun OamClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 *
 * Unlike tagging permissions in other Amazon Web Services services, to tag or untag links and sinks you must have the `oam:ResourceTag` permission. The `iam:TagResource` permission does not allow you to tag and untag links and sinks.
 */
public suspend inline fun OamClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Use this operation to change what types of data are shared from a source account to its linked monitoring account sink. You can't change the sink or change the monitoring account with this operation.
 *
 * To update the list of tags associated with the sink, use [TagResource](https://docs.aws.amazon.com/OAM/latest/APIReference/API_TagResource.html).
 */
public suspend inline fun OamClient.updateLink(crossinline block: UpdateLinkRequest.Builder.() -> Unit): UpdateLinkResponse = updateLink(UpdateLinkRequest.Builder().apply(block).build())
