// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor.serde

import aws.sdk.kotlin.services.networkmonitor.model.ProbeState
import aws.sdk.kotlin.services.networkmonitor.model.Protocol
import aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateProbeOperationSerializer: HttpSerializer.NonStreaming<UpdateProbeRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateProbeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.monitorName) { "monitorName is bound to the URI and must not be null" }
            requireNotNull(input.probeId) { "probeId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("monitors"))
                add(PercentEncoding.SmithyLabel.encode(input.monitorName))
                add(PercentEncoding.Path.encode("probes"))
                add(PercentEncoding.SmithyLabel.encode(input.probeId))
            }
        }

        val payload = serializeUpdateProbeOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateProbeOperationBody(context: ExecutionContext, input: UpdateProbeRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destination"))
    val DESTINATIONPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("destinationPort"))
    val PACKETSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("packetSize"))
    val PROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("protocol"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("state"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATION_DESCRIPTOR)
        field(DESTINATIONPORT_DESCRIPTOR)
        field(PACKETSIZE_DESCRIPTOR)
        field(PROTOCOL_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.destination?.let { field(DESTINATION_DESCRIPTOR, it) }
        input.destinationPort?.let { field(DESTINATIONPORT_DESCRIPTOR, it) }
        input.packetSize?.let { field(PACKETSIZE_DESCRIPTOR, it) }
        input.protocol?.let { field(PROTOCOL_DESCRIPTOR, it.value) }
        input.state?.let { field(STATE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
