// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor.serde

import aws.sdk.kotlin.services.networkmonitor.model.AddressFamily
import aws.sdk.kotlin.services.networkmonitor.model.GetProbeResponse
import aws.sdk.kotlin.services.networkmonitor.model.NetworkMonitorException
import aws.sdk.kotlin.services.networkmonitor.model.ProbeState
import aws.sdk.kotlin.services.networkmonitor.model.Protocol
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class GetProbeOperationDeserializer: HttpDeserializer.NonStreaming<GetProbeResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetProbeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetProbeError(context, call, payload)
        }
        val builder = GetProbeResponse.Builder()

        if (payload != null) {
            deserializeGetProbeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetProbeError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkMonitorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NetworkMonitorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetProbeOperationBody(builder: GetProbeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDRESSFAMILY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("addressFamily"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destination"))
    val DESTINATIONPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("destinationPort"))
    val MODIFIEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("modifiedAt"))
    val PACKETSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("packetSize"))
    val PROBEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("probeArn"))
    val PROBEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("probeId"))
    val PROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("protocol"))
    val SOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceArn"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("state"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDRESSFAMILY_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(DESTINATIONPORT_DESCRIPTOR)
        field(MODIFIEDAT_DESCRIPTOR)
        field(PACKETSIZE_DESCRIPTOR)
        field(PROBEARN_DESCRIPTOR)
        field(PROBEID_DESCRIPTOR)
        field(PROTOCOL_DESCRIPTOR)
        field(SOURCEARN_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDRESSFAMILY_DESCRIPTOR.index -> builder.addressFamily = deserializeString().let { AddressFamily.fromValue(it) }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESTINATION_DESCRIPTOR.index -> builder.destination = deserializeString()
                DESTINATIONPORT_DESCRIPTOR.index -> builder.destinationPort = deserializeInt()
                MODIFIEDAT_DESCRIPTOR.index -> builder.modifiedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                PACKETSIZE_DESCRIPTOR.index -> builder.packetSize = deserializeInt()
                PROBEARN_DESCRIPTOR.index -> builder.probeArn = deserializeString()
                PROBEID_DESCRIPTOR.index -> builder.probeId = deserializeString()
                PROTOCOL_DESCRIPTOR.index -> builder.protocol = deserializeString().let { Protocol.fromValue(it) }
                SOURCEARN_DESCRIPTOR.index -> builder.sourceArn = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ProbeState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VPCID_DESCRIPTOR.index -> builder.vpcId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
