// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateMonitorRequest private constructor(builder: Builder) {
    /**
     * The time, in seconds, that metrics are aggregated and sent to Amazon CloudWatch. Valid values are either `30` or `60`. `60` is the default if no period is chosen.
     */
    public val aggregationPeriod: kotlin.Long? = builder.aggregationPeriod
    /**
     * Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was provided in the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name identifying the monitor. It can contain only letters, underscores (_), or dashes (-), and can be up to 200 characters.
     */
    public val monitorName: kotlin.String? = builder.monitorName
    /**
     * Displays a list of all of the probes created for a monitor.
     */
    public val probes: List<CreateMonitorProbeInput>? = builder.probes
    /**
     * The list of key-value pairs created and assigned to the monitor.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMonitorRequest(")
        append("aggregationPeriod=$aggregationPeriod,")
        append("clientToken=$clientToken,")
        append("monitorName=$monitorName,")
        append("probes=$probes,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregationPeriod?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (monitorName?.hashCode() ?: 0)
        result = 31 * result + (probes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMonitorRequest

        if (aggregationPeriod != other.aggregationPeriod) return false
        if (clientToken != other.clientToken) return false
        if (monitorName != other.monitorName) return false
        if (probes != other.probes) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time, in seconds, that metrics are aggregated and sent to Amazon CloudWatch. Valid values are either `30` or `60`. `60` is the default if no period is chosen.
         */
        public var aggregationPeriod: kotlin.Long? = null
        /**
         * Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was provided in the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name identifying the monitor. It can contain only letters, underscores (_), or dashes (-), and can be up to 200 characters.
         */
        public var monitorName: kotlin.String? = null
        /**
         * Displays a list of all of the probes created for a monitor.
         */
        public var probes: List<CreateMonitorProbeInput>? = null
        /**
         * The list of key-value pairs created and assigned to the monitor.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorRequest) : this() {
            this.aggregationPeriod = x.aggregationPeriod
            this.clientToken = x.clientToken
            this.monitorName = x.monitorName
            this.probes = x.probes
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorRequest = CreateMonitorRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
