// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class UpdateProbeResponse private constructor(builder: Builder) {
    /**
     * The updated IP address family. This must be either `IPV4` or `IPV6`.
     */
    public val addressFamily: aws.sdk.kotlin.services.networkmonitor.model.AddressFamily? = builder.addressFamily
    /**
     * The time and date that the probe was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The updated destination IP address for the probe.
     */
    public val destination: kotlin.String = requireNotNull(builder.destination) { "A non-null value must be provided for destination" }
    /**
     * The updated destination port. This must be a number between `1` and `65536`.
     */
    public val destinationPort: kotlin.Int? = builder.destinationPort
    /**
     * The time and date that the probe was last updated.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The updated packet size for the probe.
     */
    public val packetSize: kotlin.Int? = builder.packetSize
    /**
     * The updated ARN of the probe.
     */
    public val probeArn: kotlin.String? = builder.probeArn
    /**
     * The updated ID of the probe.
     */
    public val probeId: kotlin.String? = builder.probeId
    /**
     * The updated protocol for the probe.
     */
    public val protocol: aws.sdk.kotlin.services.networkmonitor.model.Protocol = requireNotNull(builder.protocol) { "A non-null value must be provided for protocol" }
    /**
     * The updated ARN of the source subnet.
     */
    public val sourceArn: kotlin.String = requireNotNull(builder.sourceArn) { "A non-null value must be provided for sourceArn" }
    /**
     * The state of the updated probe.
     */
    public val state: aws.sdk.kotlin.services.networkmonitor.model.ProbeState? = builder.state
    /**
     * Update tags for a probe.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The updated ID of the source VPC subnet ID.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateProbeResponse(")
        append("addressFamily=$addressFamily,")
        append("createdAt=$createdAt,")
        append("destination=$destination,")
        append("destinationPort=$destinationPort,")
        append("modifiedAt=$modifiedAt,")
        append("packetSize=$packetSize,")
        append("probeArn=$probeArn,")
        append("probeId=$probeId,")
        append("protocol=$protocol,")
        append("sourceArn=$sourceArn,")
        append("state=$state,")
        append("tags=$tags,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFamily?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (destination.hashCode())
        result = 31 * result + (destinationPort ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (packetSize ?: 0)
        result = 31 * result + (probeArn?.hashCode() ?: 0)
        result = 31 * result + (probeId?.hashCode() ?: 0)
        result = 31 * result + (protocol.hashCode())
        result = 31 * result + (sourceArn.hashCode())
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateProbeResponse

        if (addressFamily != other.addressFamily) return false
        if (createdAt != other.createdAt) return false
        if (destination != other.destination) return false
        if (destinationPort != other.destinationPort) return false
        if (modifiedAt != other.modifiedAt) return false
        if (packetSize != other.packetSize) return false
        if (probeArn != other.probeArn) return false
        if (probeId != other.probeId) return false
        if (protocol != other.protocol) return false
        if (sourceArn != other.sourceArn) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The updated IP address family. This must be either `IPV4` or `IPV6`.
         */
        public var addressFamily: aws.sdk.kotlin.services.networkmonitor.model.AddressFamily? = null
        /**
         * The time and date that the probe was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The updated destination IP address for the probe.
         */
        public var destination: kotlin.String? = null
        /**
         * The updated destination port. This must be a number between `1` and `65536`.
         */
        public var destinationPort: kotlin.Int? = null
        /**
         * The time and date that the probe was last updated.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The updated packet size for the probe.
         */
        public var packetSize: kotlin.Int? = null
        /**
         * The updated ARN of the probe.
         */
        public var probeArn: kotlin.String? = null
        /**
         * The updated ID of the probe.
         */
        public var probeId: kotlin.String? = null
        /**
         * The updated protocol for the probe.
         */
        public var protocol: aws.sdk.kotlin.services.networkmonitor.model.Protocol? = null
        /**
         * The updated ARN of the source subnet.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The state of the updated probe.
         */
        public var state: aws.sdk.kotlin.services.networkmonitor.model.ProbeState? = null
        /**
         * Update tags for a probe.
         */
        public var tags: Map<String, String>? = null
        /**
         * The updated ID of the source VPC subnet ID.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeResponse) : this() {
            this.addressFamily = x.addressFamily
            this.createdAt = x.createdAt
            this.destination = x.destination
            this.destinationPort = x.destinationPort
            this.modifiedAt = x.modifiedAt
            this.packetSize = x.packetSize
            this.probeArn = x.probeArn
            this.probeId = x.probeId
            this.protocol = x.protocol
            this.sourceArn = x.sourceArn
            this.state = x.state
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeResponse = UpdateProbeResponse(this)

        internal fun correctErrors(): Builder {
            if (destination == null) destination = ""
            if (protocol == null) protocol = Protocol.SdkUnknown("no value provided")
            if (sourceArn == null) sourceArn = ""
            return this
        }
    }
}
