// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Creates a monitor probe.
 */
public class CreateMonitorProbeInput private constructor(builder: Builder) {
    /**
     * The destination IP address. This must be either `IPV4` or `IPV6`.
     */
    public val destination: kotlin.String = requireNotNull(builder.destination) { "A non-null value must be provided for destination" }
    /**
     * The port associated with the `destination`. This is required only if the `protocol` is `TCP` and must be a number between `1` and `65536`.
     */
    public val destinationPort: kotlin.Int? = builder.destinationPort
    /**
     * The size of the packets sent between the source and destination. This must be a number between `56` and `8500`.
     */
    public val packetSize: kotlin.Int? = builder.packetSize
    /**
     * The list of key-value pairs created and assigned to the monitor.
     */
    public val probeTags: Map<String, String>? = builder.probeTags
    /**
     * The protocol used for the network traffic between the `source` and `destination`. This must be either `TCP` or `ICMP`.
     */
    public val protocol: aws.sdk.kotlin.services.networkmonitor.model.Protocol = requireNotNull(builder.protocol) { "A non-null value must be provided for protocol" }
    /**
     * The ARN of the subnet.
     */
    public val sourceArn: kotlin.String = requireNotNull(builder.sourceArn) { "A non-null value must be provided for sourceArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorProbeInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMonitorProbeInput(")
        append("destination=$destination,")
        append("destinationPort=$destinationPort,")
        append("packetSize=$packetSize,")
        append("probeTags=$probeTags,")
        append("protocol=$protocol,")
        append("sourceArn=$sourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination.hashCode()
        result = 31 * result + (destinationPort ?: 0)
        result = 31 * result + (packetSize ?: 0)
        result = 31 * result + (probeTags?.hashCode() ?: 0)
        result = 31 * result + (protocol.hashCode())
        result = 31 * result + (sourceArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMonitorProbeInput

        if (destination != other.destination) return false
        if (destinationPort != other.destinationPort) return false
        if (packetSize != other.packetSize) return false
        if (probeTags != other.probeTags) return false
        if (protocol != other.protocol) return false
        if (sourceArn != other.sourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorProbeInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The destination IP address. This must be either `IPV4` or `IPV6`.
         */
        public var destination: kotlin.String? = null
        /**
         * The port associated with the `destination`. This is required only if the `protocol` is `TCP` and must be a number between `1` and `65536`.
         */
        public var destinationPort: kotlin.Int? = null
        /**
         * The size of the packets sent between the source and destination. This must be a number between `56` and `8500`.
         */
        public var packetSize: kotlin.Int? = null
        /**
         * The list of key-value pairs created and assigned to the monitor.
         */
        public var probeTags: Map<String, String>? = null
        /**
         * The protocol used for the network traffic between the `source` and `destination`. This must be either `TCP` or `ICMP`.
         */
        public var protocol: aws.sdk.kotlin.services.networkmonitor.model.Protocol? = null
        /**
         * The ARN of the subnet.
         */
        public var sourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorProbeInput) : this() {
            this.destination = x.destination
            this.destinationPort = x.destinationPort
            this.packetSize = x.packetSize
            this.probeTags = x.probeTags
            this.protocol = x.protocol
            this.sourceArn = x.sourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorProbeInput = CreateMonitorProbeInput(this)

        internal fun correctErrors(): Builder {
            if (destination == null) destination = ""
            if (protocol == null) protocol = Protocol.SdkUnknown("no value provided")
            if (sourceArn == null) sourceArn = ""
            return this
        }
    }
}
