// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor.model



public class UpdateProbeRequest private constructor(builder: Builder) {
    /**
     * The updated IP address for the probe destination. This must be either an IPv4 or IPv6 address.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The updated port for the probe destination. This is required only if the `protocol` is `TCP` and must be a number between `1` and `65536`.
     */
    public val destinationPort: kotlin.Int? = builder.destinationPort
    /**
     * The name of the monitor that the probe was updated for.
     */
    public val monitorName: kotlin.String? = builder.monitorName
    /**
     * he updated packets size for network traffic between the source and destination. This must be a number between `56` and `8500`.
     */
    public val packetSize: kotlin.Int? = builder.packetSize
    /**
     * Run `GetMonitor` to get a list of probes and probe IDs.
     */
    public val probeId: kotlin.String? = builder.probeId
    /**
     * The updated network protocol for the destination. This can be either `TCP` or `ICMP`. If the protocol is `TCP`, then `port` is also required.
     */
    public val protocol: aws.sdk.kotlin.services.networkmonitor.model.Protocol? = builder.protocol
    /**
     * The state of the probe update.
     */
    public val state: aws.sdk.kotlin.services.networkmonitor.model.ProbeState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateProbeRequest(")
        append("destination=$destination,")
        append("destinationPort=$destinationPort,")
        append("monitorName=$monitorName,")
        append("packetSize=$packetSize,")
        append("probeId=$probeId,")
        append("protocol=$protocol,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (destinationPort ?: 0)
        result = 31 * result + (monitorName?.hashCode() ?: 0)
        result = 31 * result + (packetSize ?: 0)
        result = 31 * result + (probeId?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateProbeRequest

        if (destination != other.destination) return false
        if (destinationPort != other.destinationPort) return false
        if (monitorName != other.monitorName) return false
        if (packetSize != other.packetSize) return false
        if (probeId != other.probeId) return false
        if (protocol != other.protocol) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The updated IP address for the probe destination. This must be either an IPv4 or IPv6 address.
         */
        public var destination: kotlin.String? = null
        /**
         * The updated port for the probe destination. This is required only if the `protocol` is `TCP` and must be a number between `1` and `65536`.
         */
        public var destinationPort: kotlin.Int? = null
        /**
         * The name of the monitor that the probe was updated for.
         */
        public var monitorName: kotlin.String? = null
        /**
         * he updated packets size for network traffic between the source and destination. This must be a number between `56` and `8500`.
         */
        public var packetSize: kotlin.Int? = null
        /**
         * Run `GetMonitor` to get a list of probes and probe IDs.
         */
        public var probeId: kotlin.String? = null
        /**
         * The updated network protocol for the destination. This can be either `TCP` or `ICMP`. If the protocol is `TCP`, then `port` is also required.
         */
        public var protocol: aws.sdk.kotlin.services.networkmonitor.model.Protocol? = null
        /**
         * The state of the probe update.
         */
        public var state: aws.sdk.kotlin.services.networkmonitor.model.ProbeState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeRequest) : this() {
            this.destination = x.destination
            this.destinationPort = x.destinationPort
            this.monitorName = x.monitorName
            this.packetSize = x.packetSize
            this.probeId = x.probeId
            this.protocol = x.protocol
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeRequest = UpdateProbeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
