// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor.model



/**
 * Displays summary information about a monitor.
 */
public class MonitorSummary private constructor(builder: Builder) {
    /**
     * The time, in seconds, that metrics are collected and sent to Amazon CloudWatch. Valid values are either `30` or `60`.
     */
    public val aggregationPeriod: kotlin.Long? = builder.aggregationPeriod
    /**
     * The ARN of the monitor.
     */
    public val monitorArn: kotlin.String = requireNotNull(builder.monitorArn) { "A non-null value must be provided for monitorArn" }
    /**
     * The name of the monitor.
     */
    public val monitorName: kotlin.String = requireNotNull(builder.monitorName) { "A non-null value must be provided for monitorName" }
    /**
     * The state of the monitor.
     */
    public val state: aws.sdk.kotlin.services.networkmonitor.model.MonitorState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The list of key-value pairs assigned to the monitor.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmonitor.model.MonitorSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitorSummary(")
        append("aggregationPeriod=$aggregationPeriod,")
        append("monitorArn=$monitorArn,")
        append("monitorName=$monitorName,")
        append("state=$state,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregationPeriod?.hashCode() ?: 0
        result = 31 * result + (monitorArn.hashCode())
        result = 31 * result + (monitorName.hashCode())
        result = 31 * result + (state.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitorSummary

        if (aggregationPeriod != other.aggregationPeriod) return false
        if (monitorArn != other.monitorArn) return false
        if (monitorName != other.monitorName) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmonitor.model.MonitorSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time, in seconds, that metrics are collected and sent to Amazon CloudWatch. Valid values are either `30` or `60`.
         */
        public var aggregationPeriod: kotlin.Long? = null
        /**
         * The ARN of the monitor.
         */
        public var monitorArn: kotlin.String? = null
        /**
         * The name of the monitor.
         */
        public var monitorName: kotlin.String? = null
        /**
         * The state of the monitor.
         */
        public var state: aws.sdk.kotlin.services.networkmonitor.model.MonitorState? = null
        /**
         * The list of key-value pairs assigned to the monitor.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmonitor.model.MonitorSummary) : this() {
            this.aggregationPeriod = x.aggregationPeriod
            this.monitorArn = x.monitorArn
            this.monitorName = x.monitorName
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmonitor.model.MonitorSummary = MonitorSummary(this)

        internal fun correctErrors(): Builder {
            if (monitorArn == null) monitorArn = ""
            if (monitorName == null) monitorName = ""
            if (state == null) state = MonitorState.SdkUnknown("no value provided")
            return this
        }
    }
}
