// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateProbeResponse private constructor(builder: Builder) {
    /**
     * Indicates whether the IP address is `IPV4` or `IPV6`.
     */
    public val addressFamily: aws.sdk.kotlin.services.networkmonitor.model.AddressFamily? = builder.addressFamily
    /**
     * The time and date that the probe was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The destination IP address for the monitor. This will be either an IPv4 or IPv6 address.
     */
    public val destination: kotlin.String = requireNotNull(builder.destination) { "A non-null value must be provided for destination" }
    /**
     * The port associated with the `destination`. This is required only if the `protocol` is `TCP` and must be a number between `1` and `65536`.
     */
    public val destinationPort: kotlin.Int? = builder.destinationPort
    /**
     * The time and date when the probe was last modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The size of the packets sent between the source and destination. This will be a number between `56` and `8500`.
     */
    public val packetSize: kotlin.Int? = builder.packetSize
    /**
     * The ARN of the probe.
     */
    public val probeArn: kotlin.String? = builder.probeArn
    /**
     * The ID of the probe for which details are returned.
     */
    public val probeId: kotlin.String? = builder.probeId
    /**
     * The protocol used for the network traffic between the `source` and `destination`. This will be either `TCP` or `ICMP`.
     */
    public val protocol: aws.sdk.kotlin.services.networkmonitor.model.Protocol = requireNotNull(builder.protocol) { "A non-null value must be provided for protocol" }
    /**
     * The ARN of the probe.
     */
    public val sourceArn: kotlin.String = requireNotNull(builder.sourceArn) { "A non-null value must be provided for sourceArn" }
    /**
     * The state of the probe.
     */
    public val state: aws.sdk.kotlin.services.networkmonitor.model.ProbeState? = builder.state
    /**
     * The list of key-value pairs assigned to the probe.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The ID of the source VPC or subnet.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmonitor.model.CreateProbeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProbeResponse(")
        append("addressFamily=$addressFamily,")
        append("createdAt=$createdAt,")
        append("destination=$destination,")
        append("destinationPort=$destinationPort,")
        append("modifiedAt=$modifiedAt,")
        append("packetSize=$packetSize,")
        append("probeArn=$probeArn,")
        append("probeId=$probeId,")
        append("protocol=$protocol,")
        append("sourceArn=$sourceArn,")
        append("state=$state,")
        append("tags=$tags,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFamily?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (destination.hashCode())
        result = 31 * result + (destinationPort ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (packetSize ?: 0)
        result = 31 * result + (probeArn?.hashCode() ?: 0)
        result = 31 * result + (probeId?.hashCode() ?: 0)
        result = 31 * result + (protocol.hashCode())
        result = 31 * result + (sourceArn.hashCode())
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProbeResponse

        if (addressFamily != other.addressFamily) return false
        if (createdAt != other.createdAt) return false
        if (destination != other.destination) return false
        if (destinationPort != other.destinationPort) return false
        if (modifiedAt != other.modifiedAt) return false
        if (packetSize != other.packetSize) return false
        if (probeArn != other.probeArn) return false
        if (probeId != other.probeId) return false
        if (protocol != other.protocol) return false
        if (sourceArn != other.sourceArn) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmonitor.model.CreateProbeResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the IP address is `IPV4` or `IPV6`.
         */
        public var addressFamily: aws.sdk.kotlin.services.networkmonitor.model.AddressFamily? = null
        /**
         * The time and date that the probe was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The destination IP address for the monitor. This will be either an IPv4 or IPv6 address.
         */
        public var destination: kotlin.String? = null
        /**
         * The port associated with the `destination`. This is required only if the `protocol` is `TCP` and must be a number between `1` and `65536`.
         */
        public var destinationPort: kotlin.Int? = null
        /**
         * The time and date when the probe was last modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The size of the packets sent between the source and destination. This will be a number between `56` and `8500`.
         */
        public var packetSize: kotlin.Int? = null
        /**
         * The ARN of the probe.
         */
        public var probeArn: kotlin.String? = null
        /**
         * The ID of the probe for which details are returned.
         */
        public var probeId: kotlin.String? = null
        /**
         * The protocol used for the network traffic between the `source` and `destination`. This will be either `TCP` or `ICMP`.
         */
        public var protocol: aws.sdk.kotlin.services.networkmonitor.model.Protocol? = null
        /**
         * The ARN of the probe.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The state of the probe.
         */
        public var state: aws.sdk.kotlin.services.networkmonitor.model.ProbeState? = null
        /**
         * The list of key-value pairs assigned to the probe.
         */
        public var tags: Map<String, String>? = null
        /**
         * The ID of the source VPC or subnet.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmonitor.model.CreateProbeResponse) : this() {
            this.addressFamily = x.addressFamily
            this.createdAt = x.createdAt
            this.destination = x.destination
            this.destinationPort = x.destinationPort
            this.modifiedAt = x.modifiedAt
            this.packetSize = x.packetSize
            this.probeArn = x.probeArn
            this.probeId = x.probeId
            this.protocol = x.protocol
            this.sourceArn = x.sourceArn
            this.state = x.state
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmonitor.model.CreateProbeResponse = CreateProbeResponse(this)

        internal fun correctErrors(): Builder {
            if (destination == null) destination = ""
            if (protocol == null) protocol = Protocol.SdkUnknown("no value provided")
            if (sourceArn == null) sourceArn = ""
            return this
        }
    }
}
