// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.networkmonitor.auth.DefaultNetworkMonitorAuthSchemeProvider
import aws.sdk.kotlin.services.networkmonitor.auth.NetworkMonitorAuthSchemeProvider
import aws.sdk.kotlin.services.networkmonitor.endpoints.DefaultNetworkMonitorEndpointProvider
import aws.sdk.kotlin.services.networkmonitor.endpoints.NetworkMonitorEndpointParameters
import aws.sdk.kotlin.services.networkmonitor.endpoints.NetworkMonitorEndpointProvider
import aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorRequest
import aws.sdk.kotlin.services.networkmonitor.model.CreateMonitorResponse
import aws.sdk.kotlin.services.networkmonitor.model.CreateProbeRequest
import aws.sdk.kotlin.services.networkmonitor.model.CreateProbeResponse
import aws.sdk.kotlin.services.networkmonitor.model.DeleteMonitorRequest
import aws.sdk.kotlin.services.networkmonitor.model.DeleteMonitorResponse
import aws.sdk.kotlin.services.networkmonitor.model.DeleteProbeRequest
import aws.sdk.kotlin.services.networkmonitor.model.DeleteProbeResponse
import aws.sdk.kotlin.services.networkmonitor.model.GetMonitorRequest
import aws.sdk.kotlin.services.networkmonitor.model.GetMonitorResponse
import aws.sdk.kotlin.services.networkmonitor.model.GetProbeRequest
import aws.sdk.kotlin.services.networkmonitor.model.GetProbeResponse
import aws.sdk.kotlin.services.networkmonitor.model.ListMonitorsRequest
import aws.sdk.kotlin.services.networkmonitor.model.ListMonitorsResponse
import aws.sdk.kotlin.services.networkmonitor.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.networkmonitor.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.networkmonitor.model.TagResourceRequest
import aws.sdk.kotlin.services.networkmonitor.model.TagResourceResponse
import aws.sdk.kotlin.services.networkmonitor.model.UntagResourceRequest
import aws.sdk.kotlin.services.networkmonitor.model.UntagResourceResponse
import aws.sdk.kotlin.services.networkmonitor.model.UpdateMonitorRequest
import aws.sdk.kotlin.services.networkmonitor.model.UpdateMonitorResponse
import aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeRequest
import aws.sdk.kotlin.services.networkmonitor.model.UpdateProbeResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "NetworkMonitor"
public const val SdkVersion: String = "1.1.8"
public const val ServiceApiVersion: String = "2023-08-01"

/**
 * Amazon CloudWatch Network Monitor is an Amazon Web Services active network monitoring service that identifies if a network issues exists within the Amazon Web Services network or your own company network. Within Network Monitor you'll choose the source VPCs and subnets from the Amazon Web Services network in which you operate and then you'll choose the destination IP addresses from your on-premises network. From these sources and destinations, Network Monitor creates a monitor containing all the possible source and destination combinations, each of which is called a probe, within a single monitor. These probes then monitor network traffic to help you identify where network issues might be affecting your traffic.
 *
 * For more information, see [Using Amazon CloudWatch Network Monitor](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/what-is-network-monitor.html) in the *Amazon CloudWatch User Guide*.
 */
public interface NetworkMonitorClient : SdkClient {
    /**
     * NetworkMonitorClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, NetworkMonitorClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "NetworkMonitor",
                "NETWORKMONITOR",
                "networkmonitor",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, NetworkMonitorClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): NetworkMonitorClient = DefaultNetworkMonitorClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: NetworkMonitorEndpointProvider = builder.endpointProvider ?: DefaultNetworkMonitorEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: NetworkMonitorAuthSchemeProvider = builder.authSchemeProvider ?: DefaultNetworkMonitorAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "NetworkMonitor"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: NetworkMonitorEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: NetworkMonitorAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a monitor between a source subnet and destination IP address. Within a monitor you'll create one or more probes that monitor network traffic between your source Amazon Web Services VPC subnets and your destination IP addresses. Each probe then aggregates and sends metrics to Amazon CloudWatch.
     */
    public suspend fun createMonitor(input: CreateMonitorRequest): CreateMonitorResponse

    /**
     * Create a probe within a monitor. Once you create a probe, and it begins monitoring your network traffic, you'll incur billing charges for that probe.
     */
    public suspend fun createProbe(input: CreateProbeRequest): CreateProbeResponse

    /**
     * Deletes a specified monitor.
     */
    public suspend fun deleteMonitor(input: DeleteMonitorRequest): DeleteMonitorResponse

    /**
     * Deletes the specified monitor. Once a probe is deleted you'll no longer incur any billing fees for that probe.
     */
    public suspend fun deleteProbe(input: DeleteProbeRequest): DeleteProbeResponse

    /**
     * Returns details about a specific monitor.
     */
    public suspend fun getMonitor(input: GetMonitorRequest): GetMonitorResponse

    /**
     * Returns the details about a probe. You'll need both the `monitorName` and `probeId`.
     */
    public suspend fun getProbe(input: GetProbeRequest): GetProbeResponse

    /**
     * Returns a list of all of your monitors.
     */
    public suspend fun listMonitors(input: ListMonitorsRequest = ListMonitorsRequest { }): ListMonitorsResponse

    /**
     * Lists the tags assigned to this resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds key-value pairs to a monitor or probe.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a key-value pair from a monitor or probe.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the `aggregationPeriod` for a monitor. Monitors support an `aggregationPeriod` of either `30` or `60` seconds.
     */
    public suspend fun updateMonitor(input: UpdateMonitorRequest): UpdateMonitorResponse

    /**
     * Updates a monitor probe. This action requires both the `monitorName` and `probeId` parameters. Run `ListMonitors` to get a list of monitor names. Run `GetMonitor` to get a list of probes and probe IDs.
     */
    public suspend fun updateProbe(input: UpdateProbeRequest): UpdateProbeResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun NetworkMonitorClient.withConfig(block: NetworkMonitorClient.Config.Builder.() -> Unit): NetworkMonitorClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultNetworkMonitorClient(newConfig)
}

/**
 * Creates a monitor between a source subnet and destination IP address. Within a monitor you'll create one or more probes that monitor network traffic between your source Amazon Web Services VPC subnets and your destination IP addresses. Each probe then aggregates and sends metrics to Amazon CloudWatch.
 */
public suspend inline fun NetworkMonitorClient.createMonitor(crossinline block: CreateMonitorRequest.Builder.() -> Unit): CreateMonitorResponse = createMonitor(CreateMonitorRequest.Builder().apply(block).build())

/**
 * Create a probe within a monitor. Once you create a probe, and it begins monitoring your network traffic, you'll incur billing charges for that probe.
 */
public suspend inline fun NetworkMonitorClient.createProbe(crossinline block: CreateProbeRequest.Builder.() -> Unit): CreateProbeResponse = createProbe(CreateProbeRequest.Builder().apply(block).build())

/**
 * Deletes a specified monitor.
 */
public suspend inline fun NetworkMonitorClient.deleteMonitor(crossinline block: DeleteMonitorRequest.Builder.() -> Unit): DeleteMonitorResponse = deleteMonitor(DeleteMonitorRequest.Builder().apply(block).build())

/**
 * Deletes the specified monitor. Once a probe is deleted you'll no longer incur any billing fees for that probe.
 */
public suspend inline fun NetworkMonitorClient.deleteProbe(crossinline block: DeleteProbeRequest.Builder.() -> Unit): DeleteProbeResponse = deleteProbe(DeleteProbeRequest.Builder().apply(block).build())

/**
 * Returns details about a specific monitor.
 */
public suspend inline fun NetworkMonitorClient.getMonitor(crossinline block: GetMonitorRequest.Builder.() -> Unit): GetMonitorResponse = getMonitor(GetMonitorRequest.Builder().apply(block).build())

/**
 * Returns the details about a probe. You'll need both the `monitorName` and `probeId`.
 */
public suspend inline fun NetworkMonitorClient.getProbe(crossinline block: GetProbeRequest.Builder.() -> Unit): GetProbeResponse = getProbe(GetProbeRequest.Builder().apply(block).build())

/**
 * Returns a list of all of your monitors.
 */
public suspend inline fun NetworkMonitorClient.listMonitors(crossinline block: ListMonitorsRequest.Builder.() -> Unit): ListMonitorsResponse = listMonitors(ListMonitorsRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to this resource.
 */
public suspend inline fun NetworkMonitorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds key-value pairs to a monitor or probe.
 */
public suspend inline fun NetworkMonitorClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a key-value pair from a monitor or probe.
 */
public suspend inline fun NetworkMonitorClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the `aggregationPeriod` for a monitor. Monitors support an `aggregationPeriod` of either `30` or `60` seconds.
 */
public suspend inline fun NetworkMonitorClient.updateMonitor(crossinline block: UpdateMonitorRequest.Builder.() -> Unit): UpdateMonitorResponse = updateMonitor(UpdateMonitorRequest.Builder().apply(block).build())

/**
 * Updates a monitor probe. This action requires both the `monitorName` and `probeId` parameters. Run `ListMonitors` to get a list of monitor names. Run `GetMonitor` to get a list of probes and probe IDs.
 */
public suspend inline fun NetworkMonitorClient.updateProbe(crossinline block: UpdateProbeRequest.Builder.() -> Unit): UpdateProbeResponse = updateProbe(UpdateProbeRequest.Builder().apply(block).build())
