// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmonitor.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetMonitorResponse private constructor(builder: Builder) {
    /**
     * The aggregation period for the specified monitor.
     */
    public val aggregationPeriod: kotlin.Long = requireNotNull(builder.aggregationPeriod) { "A non-null value must be provided for aggregationPeriod" }
    /**
     * The time and date when the monitor was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The time and date when the monitor was last modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The ARN of the selected monitor.
     */
    public val monitorArn: kotlin.String = requireNotNull(builder.monitorArn) { "A non-null value must be provided for monitorArn" }
    /**
     * The name of the monitor. To get a list of the current monitors and their names, use the `ListMonitors` action.
     */
    public val monitorName: kotlin.String = requireNotNull(builder.monitorName) { "A non-null value must be provided for monitorName" }
    /**
     * The details about each probe associated with that monitor.
     */
    public val probes: List<Probe>? = builder.probes
    /**
     * Returns a list of the state of each monitor.
     */
    public val state: aws.sdk.kotlin.services.networkmonitor.model.MonitorState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The list of key-value pairs assigned to the monitor.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmonitor.model.GetMonitorResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMonitorResponse(")
        append("aggregationPeriod=$aggregationPeriod,")
        append("createdAt=$createdAt,")
        append("modifiedAt=$modifiedAt,")
        append("monitorArn=$monitorArn,")
        append("monitorName=$monitorName,")
        append("probes=$probes,")
        append("state=$state,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregationPeriod.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (monitorArn.hashCode())
        result = 31 * result + (monitorName.hashCode())
        result = 31 * result + (probes?.hashCode() ?: 0)
        result = 31 * result + (state.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMonitorResponse

        if (aggregationPeriod != other.aggregationPeriod) return false
        if (createdAt != other.createdAt) return false
        if (modifiedAt != other.modifiedAt) return false
        if (monitorArn != other.monitorArn) return false
        if (monitorName != other.monitorName) return false
        if (probes != other.probes) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmonitor.model.GetMonitorResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The aggregation period for the specified monitor.
         */
        public var aggregationPeriod: kotlin.Long? = null
        /**
         * The time and date when the monitor was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time and date when the monitor was last modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the selected monitor.
         */
        public var monitorArn: kotlin.String? = null
        /**
         * The name of the monitor. To get a list of the current monitors and their names, use the `ListMonitors` action.
         */
        public var monitorName: kotlin.String? = null
        /**
         * The details about each probe associated with that monitor.
         */
        public var probes: List<Probe>? = null
        /**
         * Returns a list of the state of each monitor.
         */
        public var state: aws.sdk.kotlin.services.networkmonitor.model.MonitorState? = null
        /**
         * The list of key-value pairs assigned to the monitor.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmonitor.model.GetMonitorResponse) : this() {
            this.aggregationPeriod = x.aggregationPeriod
            this.createdAt = x.createdAt
            this.modifiedAt = x.modifiedAt
            this.monitorArn = x.monitorArn
            this.monitorName = x.monitorName
            this.probes = x.probes
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmonitor.model.GetMonitorResponse = GetMonitorResponse(this)

        internal fun correctErrors(): Builder {
            if (aggregationPeriod == null) aggregationPeriod = 0L
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            if (monitorArn == null) monitorArn = ""
            if (monitorName == null) monitorName = ""
            if (state == null) state = MonitorState.SdkUnknown("no value provided")
            return this
        }
    }
}
