// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.transform

import aws.sdk.kotlin.services.networkmanager.model.CoreNetworkPolicy
import aws.sdk.kotlin.services.networkmanager.model.NetworkManagerException
import aws.sdk.kotlin.services.networkmanager.model.PutCoreNetworkPolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutCoreNetworkPolicyOperationDeserializer: HttpDeserialize<PutCoreNetworkPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutCoreNetworkPolicyResponse {
        if (!response.status.isSuccess()) {
            throwPutCoreNetworkPolicyError(context, response)
        }
        val builder = PutCoreNetworkPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutCoreNetworkPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutCoreNetworkPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkManagerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "CoreNetworkPolicyException" -> CoreNetworkPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> NetworkManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutCoreNetworkPolicyOperationBody(builder: PutCoreNetworkPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CORENETWORKPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CoreNetworkPolicy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CORENETWORKPOLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CORENETWORKPOLICY_DESCRIPTOR.index -> builder.coreNetworkPolicy = deserializeCoreNetworkPolicyDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
