// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.transform

import aws.sdk.kotlin.services.networkmanager.model.Bandwidth
import aws.sdk.kotlin.services.networkmanager.model.CreateLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateLinkOperationSerializer: HttpSerialize<CreateLinkRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateLinkRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "global-networks",
                "${input.globalNetworkId}".encodeLabel(),
                "links",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateLinkOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateLinkOperationBody(context: ExecutionContext, input: CreateLinkRequest): ByteArray {
    val serializer = JsonSerializer()
    val BANDWIDTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Bandwidth"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val PROVIDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Provider"))
    val SITEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SiteId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BANDWIDTH_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(PROVIDER_DESCRIPTOR)
        field(SITEID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.bandwidth?.let { field(BANDWIDTH_DESCRIPTOR, it, ::serializeBandwidthDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.provider?.let { field(PROVIDER_DESCRIPTOR, it) }
        input.siteId?.let { field(SITEID_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.type?.let { field(TYPE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
