// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.transform

import aws.sdk.kotlin.services.networkmanager.model.CreateConnectionRequest
import aws.sdk.kotlin.services.networkmanager.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateConnectionOperationSerializer: HttpSerialize<CreateConnectionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateConnectionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "global-networks",
                "${input.globalNetworkId}".encodeLabel(),
                "connections",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateConnectionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateConnectionOperationBody(context: ExecutionContext, input: CreateConnectionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONNECTEDDEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectedDeviceId"))
    val CONNECTEDLINKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectedLinkId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceId"))
    val LINKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LinkId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTEDDEVICEID_DESCRIPTOR)
        field(CONNECTEDLINKID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DEVICEID_DESCRIPTOR)
        field(LINKID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.connectedDeviceId?.let { field(CONNECTEDDEVICEID_DESCRIPTOR, it) }
        input.connectedLinkId?.let { field(CONNECTEDLINKID_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.deviceId?.let { field(DEVICEID_DESCRIPTOR, it) }
        input.linkId?.let { field(LINKID_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
