// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a core network change event. This can be a change to a segment, attachment, route, etc.
 */
public class CoreNetworkChangeEvent private constructor(builder: Builder) {
    /**
     * The action taken for the change event.
     */
    public val action: aws.sdk.kotlin.services.networkmanager.model.ChangeAction? = builder.action
    /**
     * The timestamp for an event change in status.
     */
    public val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * Uniquely identifies the path for a change within the changeset. For example, the `IdentifierPath` for a core network segment change might be `"CORE_NETWORK_SEGMENT/us-east-1/devsegment"`.
     */
    public val identifierPath: kotlin.String? = builder.identifierPath
    /**
     * The status of the core network change event.
     */
    public val status: aws.sdk.kotlin.services.networkmanager.model.ChangeStatus? = builder.status
    /**
     * Describes the type of change event.
     */
    public val type: aws.sdk.kotlin.services.networkmanager.model.ChangeType? = builder.type
    /**
     * Details of the change event.
     */
    public val values: aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEventValues? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CoreNetworkChangeEvent(")
        append("action=$action,")
        append("eventTime=$eventTime,")
        append("identifierPath=$identifierPath,")
        append("status=$status,")
        append("type=$type,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (identifierPath?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CoreNetworkChangeEvent

        if (action != other.action) return false
        if (eventTime != other.eventTime) return false
        if (identifierPath != other.identifierPath) return false
        if (status != other.status) return false
        if (type != other.type) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEvent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action taken for the change event.
         */
        public var action: aws.sdk.kotlin.services.networkmanager.model.ChangeAction? = null
        /**
         * The timestamp for an event change in status.
         */
        public var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Uniquely identifies the path for a change within the changeset. For example, the `IdentifierPath` for a core network segment change might be `"CORE_NETWORK_SEGMENT/us-east-1/devsegment"`.
         */
        public var identifierPath: kotlin.String? = null
        /**
         * The status of the core network change event.
         */
        public var status: aws.sdk.kotlin.services.networkmanager.model.ChangeStatus? = null
        /**
         * Describes the type of change event.
         */
        public var type: aws.sdk.kotlin.services.networkmanager.model.ChangeType? = null
        /**
         * Details of the change event.
         */
        public var values: aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEventValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEvent) : this() {
            this.action = x.action
            this.eventTime = x.eventTime
            this.identifierPath = x.identifierPath
            this.status = x.status
            this.type = x.type
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEvent = CoreNetworkChangeEvent(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEventValues] inside the given [block]
         */
        public fun values(block: aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEventValues.Builder.() -> kotlin.Unit) {
            this.values = aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEventValues.invoke(block)
        }
    }
}
