// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.networkmanager.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.networkmanager.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.networkmanager.model.*
import aws.sdk.kotlin.services.networkmanager.model.AcceptAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.AssociateConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.AssociateCustomerGatewayRequest
import aws.sdk.kotlin.services.networkmanager.model.AssociateLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectionRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateCoreNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateDeviceRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateGlobalNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateSiteRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateTransitGatewayPeeringRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateVpcAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteCoreNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteDeviceRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteGlobalNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.DeletePeeringRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteSiteRequest
import aws.sdk.kotlin.services.networkmanager.model.DeregisterTransitGatewayRequest
import aws.sdk.kotlin.services.networkmanager.model.DescribeGlobalNetworksRequest
import aws.sdk.kotlin.services.networkmanager.model.DisassociateConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.DisassociateCustomerGatewayRequest
import aws.sdk.kotlin.services.networkmanager.model.DisassociateLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectPeerAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectionsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeEventsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeSetRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkPolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCustomerGatewayAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetDevicesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetLinkAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetLinksRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceCountsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceRelationshipsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourcesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkRoutesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkTelemetryRequest
import aws.sdk.kotlin.services.networkmanager.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.GetRouteAnalysisRequest
import aws.sdk.kotlin.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.GetSitesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayPeeringRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayRegistrationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.GetVpcAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.ListAttachmentsRequest
import aws.sdk.kotlin.services.networkmanager.model.ListConnectPeersRequest
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworksRequest
import aws.sdk.kotlin.services.networkmanager.model.ListOrganizationServiceAccessStatusRequest
import aws.sdk.kotlin.services.networkmanager.model.ListPeeringsRequest
import aws.sdk.kotlin.services.networkmanager.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.networkmanager.model.PutCoreNetworkPolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.RegisterTransitGatewayRequest
import aws.sdk.kotlin.services.networkmanager.model.RejectAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.RestoreCoreNetworkPolicyVersionRequest
import aws.sdk.kotlin.services.networkmanager.model.StartOrganizationServiceAccessUpdateRequest
import aws.sdk.kotlin.services.networkmanager.model.StartRouteAnalysisRequest
import aws.sdk.kotlin.services.networkmanager.model.TagResourceRequest
import aws.sdk.kotlin.services.networkmanager.model.UntagResourceRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateConnectionRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateCoreNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateDeviceRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateGlobalNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateNetworkResourceMetadataRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateSiteRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateVpcAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "NetworkManager"
public const val ServiceApiVersion: String = "2019-07-05"
public const val SdkVersion: String = "0.20.3-beta"

internal class DefaultNetworkManagerClient(override val config: NetworkManagerClient.Config) : NetworkManagerClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accepts a core network attachment request.
     *
     * Once the attachment request is accepted by a core network owner, the attachment is created and connected to a core network.
     */
    override suspend fun acceptAttachment(input: AcceptAttachmentRequest): AcceptAttachmentResponse {
        val op = SdkHttpOperation.build<AcceptAttachmentRequest, AcceptAttachmentResponse> {
            serializer = AcceptAttachmentOperationSerializer()
            deserializer = AcceptAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AcceptAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AcceptAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a core network Connect peer with a device and optionally, with a link.
     *
     * If you specify a link, it must be associated with the specified device. You can only associate core network Connect peers that have been created on a core network Connect attachment on a core network.
     */
    override suspend fun associateConnectPeer(input: AssociateConnectPeerRequest): AssociateConnectPeerResponse {
        val op = SdkHttpOperation.build<AssociateConnectPeerRequest, AssociateConnectPeerResponse> {
            serializer = AssociateConnectPeerOperationSerializer()
            deserializer = AssociateConnectPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateConnectPeer"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateConnectPeerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateConnectPeer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device.
     *
     * You can only associate customer gateways that are connected to a VPN attachment on a transit gateway or core network registered in your global network. When you register a transit gateway or core network, customer gateways that are connected to the transit gateway are automatically included in the global network. To list customer gateways that are connected to a transit gateway, use the [DescribeVpnConnections](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html) EC2 API and filter by `transit-gateway-id`.
     *
     * You cannot associate a customer gateway with more than one device and link.
     */
    override suspend fun associateCustomerGateway(input: AssociateCustomerGatewayRequest): AssociateCustomerGatewayResponse {
        val op = SdkHttpOperation.build<AssociateCustomerGatewayRequest, AssociateCustomerGatewayResponse> {
            serializer = AssociateCustomerGatewayOperationSerializer()
            deserializer = AssociateCustomerGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateCustomerGateway"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateCustomerGatewayRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateCustomerGateway-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.
     */
    override suspend fun associateLink(input: AssociateLinkRequest): AssociateLinkResponse {
        val op = SdkHttpOperation.build<AssociateLinkRequest, AssociateLinkResponse> {
            serializer = AssociateLinkOperationSerializer()
            deserializer = AssociateLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateLink"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateLinkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateLink-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it must be associated with the specified device.
     *
     * You can only associate transit gateway Connect peers that have been created on a transit gateway that's registered in your global network.
     *
     * You cannot associate a transit gateway Connect peer with more than one device and link.
     */
    override suspend fun associateTransitGatewayConnectPeer(input: AssociateTransitGatewayConnectPeerRequest): AssociateTransitGatewayConnectPeerResponse {
        val op = SdkHttpOperation.build<AssociateTransitGatewayConnectPeerRequest, AssociateTransitGatewayConnectPeerResponse> {
            serializer = AssociateTransitGatewayConnectPeerOperationSerializer()
            deserializer = AssociateTransitGatewayConnectPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateTransitGatewayConnectPeer"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateTransitGatewayConnectPeerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateTransitGatewayConnectPeer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a core network Connect attachment from a specified core network attachment.
     *
     * A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the underlying transport mechanism.
     */
    override suspend fun createConnectAttachment(input: CreateConnectAttachmentRequest): CreateConnectAttachmentResponse {
        val op = SdkHttpOperation.build<CreateConnectAttachmentRequest, CreateConnectAttachmentResponse> {
            serializer = CreateConnectAttachmentOperationSerializer()
            deserializer = CreateConnectAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConnectAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateConnectAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateConnectAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a core network Connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     */
    override suspend fun createConnectPeer(input: CreateConnectPeerRequest): CreateConnectPeerResponse {
        val op = SdkHttpOperation.build<CreateConnectPeerRequest, CreateConnectPeerResponse> {
            serializer = CreateConnectPeerOperationSerializer()
            deserializer = CreateConnectPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConnectPeer"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateConnectPeerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateConnectPeer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.
     */
    override suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse {
        val op = SdkHttpOperation.build<CreateConnectionRequest, CreateConnectionResponse> {
            serializer = CreateConnectionOperationSerializer()
            deserializer = CreateConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a core network as part of your global network, and optionally, with a core network policy.
     */
    override suspend fun createCoreNetwork(input: CreateCoreNetworkRequest): CreateCoreNetworkResponse {
        val op = SdkHttpOperation.build<CreateCoreNetworkRequest, CreateCoreNetworkResponse> {
            serializer = CreateCoreNetworkOperationSerializer()
            deserializer = CreateCoreNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCoreNetwork"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateCoreNetworkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateCoreNetwork-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.
     */
    override suspend fun createDevice(input: CreateDeviceRequest): CreateDeviceResponse {
        val op = SdkHttpOperation.build<CreateDeviceRequest, CreateDeviceResponse> {
            serializer = CreateDeviceOperationSerializer()
            deserializer = CreateDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDevice"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateDeviceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDevice-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new, empty global network.
     */
    override suspend fun createGlobalNetwork(input: CreateGlobalNetworkRequest): CreateGlobalNetworkResponse {
        val op = SdkHttpOperation.build<CreateGlobalNetworkRequest, CreateGlobalNetworkResponse> {
            serializer = CreateGlobalNetworkOperationSerializer()
            deserializer = CreateGlobalNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGlobalNetwork"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateGlobalNetworkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateGlobalNetwork-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new link for a specified site.
     */
    override suspend fun createLink(input: CreateLinkRequest): CreateLinkResponse {
        val op = SdkHttpOperation.build<CreateLinkRequest, CreateLinkResponse> {
            serializer = CreateLinkOperationSerializer()
            deserializer = CreateLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLink"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateLinkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateLink-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new site in a global network.
     */
    override suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse {
        val op = SdkHttpOperation.build<CreateSiteRequest, CreateSiteResponse> {
            serializer = CreateSiteOperationSerializer()
            deserializer = CreateSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSite"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateSiteRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSite-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network.
     */
    override suspend fun createSiteToSiteVpnAttachment(input: CreateSiteToSiteVpnAttachmentRequest): CreateSiteToSiteVpnAttachmentResponse {
        val op = SdkHttpOperation.build<CreateSiteToSiteVpnAttachmentRequest, CreateSiteToSiteVpnAttachmentResponse> {
            serializer = CreateSiteToSiteVpnAttachmentOperationSerializer()
            deserializer = CreateSiteToSiteVpnAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSiteToSiteVpnAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateSiteToSiteVpnAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSiteToSiteVpnAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a transit gateway peering connection.
     */
    override suspend fun createTransitGatewayPeering(input: CreateTransitGatewayPeeringRequest): CreateTransitGatewayPeeringResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayPeeringRequest, CreateTransitGatewayPeeringResponse> {
            serializer = CreateTransitGatewayPeeringOperationSerializer()
            deserializer = CreateTransitGatewayPeeringOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayPeering"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateTransitGatewayPeeringRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateTransitGatewayPeering-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a transit gateway route table attachment.
     */
    override suspend fun createTransitGatewayRouteTableAttachment(input: CreateTransitGatewayRouteTableAttachmentRequest): CreateTransitGatewayRouteTableAttachmentResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayRouteTableAttachmentRequest, CreateTransitGatewayRouteTableAttachmentResponse> {
            serializer = CreateTransitGatewayRouteTableAttachmentOperationSerializer()
            deserializer = CreateTransitGatewayRouteTableAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayRouteTableAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateTransitGatewayRouteTableAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateTransitGatewayRouteTableAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a VPC attachment on an edge location of a core network.
     */
    override suspend fun createVpcAttachment(input: CreateVpcAttachmentRequest): CreateVpcAttachmentResponse {
        val op = SdkHttpOperation.build<CreateVpcAttachmentRequest, CreateVpcAttachmentResponse> {
            serializer = CreateVpcAttachmentOperationSerializer()
            deserializer = CreateVpcAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVpcAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateVpcAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateVpcAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an attachment. Supports all attachment types.
     */
    override suspend fun deleteAttachment(input: DeleteAttachmentRequest): DeleteAttachmentResponse {
        val op = SdkHttpOperation.build<DeleteAttachmentRequest, DeleteAttachmentResponse> {
            serializer = DeleteAttachmentOperationSerializer()
            deserializer = DeleteAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Connect peer.
     */
    override suspend fun deleteConnectPeer(input: DeleteConnectPeerRequest): DeleteConnectPeerResponse {
        val op = SdkHttpOperation.build<DeleteConnectPeerRequest, DeleteConnectPeerResponse> {
            serializer = DeleteConnectPeerOperationSerializer()
            deserializer = DeleteConnectPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConnectPeer"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteConnectPeerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteConnectPeer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified connection in your global network.
     */
    override suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse {
        val op = SdkHttpOperation.build<DeleteConnectionRequest, DeleteConnectionResponse> {
            serializer = DeleteConnectionOperationSerializer()
            deserializer = DeleteConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a core network along with all core network policies. This can only be done if there are no attachments on a core network.
     */
    override suspend fun deleteCoreNetwork(input: DeleteCoreNetworkRequest): DeleteCoreNetworkResponse {
        val op = SdkHttpOperation.build<DeleteCoreNetworkRequest, DeleteCoreNetworkResponse> {
            serializer = DeleteCoreNetworkOperationSerializer()
            deserializer = DeleteCoreNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCoreNetwork"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteCoreNetworkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCoreNetwork-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a policy version from a core network. You can't delete the current LIVE policy.
     */
    override suspend fun deleteCoreNetworkPolicyVersion(input: DeleteCoreNetworkPolicyVersionRequest): DeleteCoreNetworkPolicyVersionResponse {
        val op = SdkHttpOperation.build<DeleteCoreNetworkPolicyVersionRequest, DeleteCoreNetworkPolicyVersionResponse> {
            serializer = DeleteCoreNetworkPolicyVersionOperationSerializer()
            deserializer = DeleteCoreNetworkPolicyVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCoreNetworkPolicyVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteCoreNetworkPolicyVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCoreNetworkPolicyVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
     */
    override suspend fun deleteDevice(input: DeleteDeviceRequest): DeleteDeviceResponse {
        val op = SdkHttpOperation.build<DeleteDeviceRequest, DeleteDeviceResponse> {
            serializer = DeleteDeviceOperationSerializer()
            deserializer = DeleteDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDevice"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteDeviceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDevice-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites), deregister all transit gateways, and delete any core networks.
     */
    override suspend fun deleteGlobalNetwork(input: DeleteGlobalNetworkRequest): DeleteGlobalNetworkResponse {
        val op = SdkHttpOperation.build<DeleteGlobalNetworkRequest, DeleteGlobalNetworkResponse> {
            serializer = DeleteGlobalNetworkOperationSerializer()
            deserializer = DeleteGlobalNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGlobalNetwork"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteGlobalNetworkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteGlobalNetwork-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
     */
    override suspend fun deleteLink(input: DeleteLinkRequest): DeleteLinkResponse {
        val op = SdkHttpOperation.build<DeleteLinkRequest, DeleteLinkResponse> {
            serializer = DeleteLinkOperationSerializer()
            deserializer = DeleteLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLink"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteLinkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteLink-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing peering connection.
     */
    override suspend fun deletePeering(input: DeletePeeringRequest): DeletePeeringResponse {
        val op = SdkHttpOperation.build<DeletePeeringRequest, DeletePeeringResponse> {
            serializer = DeletePeeringOperationSerializer()
            deserializer = DeletePeeringOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePeering"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeletePeeringRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeletePeering-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the resource policy.
     */
    override suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse> {
            serializer = DeleteResourcePolicyOperationSerializer()
            deserializer = DeleteResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResourcePolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteResourcePolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteResourcePolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing site. The site cannot be associated with any device or link.
     */
    override suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse {
        val op = SdkHttpOperation.build<DeleteSiteRequest, DeleteSiteResponse> {
            serializer = DeleteSiteOperationSerializer()
            deserializer = DeleteSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSite"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteSiteRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteSite-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.
     */
    override suspend fun deregisterTransitGateway(input: DeregisterTransitGatewayRequest): DeregisterTransitGatewayResponse {
        val op = SdkHttpOperation.build<DeregisterTransitGatewayRequest, DeregisterTransitGatewayResponse> {
            serializer = DeregisterTransitGatewayOperationSerializer()
            deserializer = DeregisterTransitGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterTransitGateway"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeregisterTransitGatewayRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeregisterTransitGateway-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate `Get*` action. For example, to list the transit gateways in your global network, use GetTransitGatewayRegistrations.
     */
    override suspend fun describeGlobalNetworks(input: DescribeGlobalNetworksRequest): DescribeGlobalNetworksResponse {
        val op = SdkHttpOperation.build<DescribeGlobalNetworksRequest, DescribeGlobalNetworksResponse> {
            serializer = DescribeGlobalNetworksOperationSerializer()
            deserializer = DescribeGlobalNetworksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGlobalNetworks"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeGlobalNetworksRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeGlobalNetworks-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates a core network Connect peer from a device and a link.
     */
    override suspend fun disassociateConnectPeer(input: DisassociateConnectPeerRequest): DisassociateConnectPeerResponse {
        val op = SdkHttpOperation.build<DisassociateConnectPeerRequest, DisassociateConnectPeerResponse> {
            serializer = DisassociateConnectPeerOperationSerializer()
            deserializer = DisassociateConnectPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateConnectPeer"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DisassociateConnectPeerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateConnectPeer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates a customer gateway from a device and a link.
     */
    override suspend fun disassociateCustomerGateway(input: DisassociateCustomerGatewayRequest): DisassociateCustomerGatewayResponse {
        val op = SdkHttpOperation.build<DisassociateCustomerGatewayRequest, DisassociateCustomerGatewayResponse> {
            serializer = DisassociateCustomerGatewayOperationSerializer()
            deserializer = DisassociateCustomerGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateCustomerGateway"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DisassociateCustomerGatewayRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateCustomerGateway-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.
     */
    override suspend fun disassociateLink(input: DisassociateLinkRequest): DisassociateLinkResponse {
        val op = SdkHttpOperation.build<DisassociateLinkRequest, DisassociateLinkResponse> {
            serializer = DisassociateLinkOperationSerializer()
            deserializer = DisassociateLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateLink"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DisassociateLinkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateLink-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates a transit gateway Connect peer from a device and link.
     */
    override suspend fun disassociateTransitGatewayConnectPeer(input: DisassociateTransitGatewayConnectPeerRequest): DisassociateTransitGatewayConnectPeerResponse {
        val op = SdkHttpOperation.build<DisassociateTransitGatewayConnectPeerRequest, DisassociateTransitGatewayConnectPeerResponse> {
            serializer = DisassociateTransitGatewayConnectPeerOperationSerializer()
            deserializer = DisassociateTransitGatewayConnectPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateTransitGatewayConnectPeer"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DisassociateTransitGatewayConnectPeerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateTransitGatewayConnectPeer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Executes a change set on your core network. Deploys changes globally based on the policy submitted..
     */
    override suspend fun executeCoreNetworkChangeSet(input: ExecuteCoreNetworkChangeSetRequest): ExecuteCoreNetworkChangeSetResponse {
        val op = SdkHttpOperation.build<ExecuteCoreNetworkChangeSetRequest, ExecuteCoreNetworkChangeSetResponse> {
            serializer = ExecuteCoreNetworkChangeSetOperationSerializer()
            deserializer = ExecuteCoreNetworkChangeSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExecuteCoreNetworkChangeSet"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ExecuteCoreNetworkChangeSetRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ExecuteCoreNetworkChangeSet-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a core network Connect attachment.
     */
    override suspend fun getConnectAttachment(input: GetConnectAttachmentRequest): GetConnectAttachmentResponse {
        val op = SdkHttpOperation.build<GetConnectAttachmentRequest, GetConnectAttachmentResponse> {
            serializer = GetConnectAttachmentOperationSerializer()
            deserializer = GetConnectAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConnectAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetConnectAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetConnectAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a core network Connect peer.
     */
    override suspend fun getConnectPeer(input: GetConnectPeerRequest): GetConnectPeerResponse {
        val op = SdkHttpOperation.build<GetConnectPeerRequest, GetConnectPeerResponse> {
            serializer = GetConnectPeerOperationSerializer()
            deserializer = GetConnectPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConnectPeer"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetConnectPeerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetConnectPeer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a core network Connect peer associations.
     */
    override suspend fun getConnectPeerAssociations(input: GetConnectPeerAssociationsRequest): GetConnectPeerAssociationsResponse {
        val op = SdkHttpOperation.build<GetConnectPeerAssociationsRequest, GetConnectPeerAssociationsResponse> {
            serializer = GetConnectPeerAssociationsOperationSerializer()
            deserializer = GetConnectPeerAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConnectPeerAssociations"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetConnectPeerAssociationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetConnectPeerAssociations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about one or more of your connections in a global network.
     */
    override suspend fun getConnections(input: GetConnectionsRequest): GetConnectionsResponse {
        val op = SdkHttpOperation.build<GetConnectionsRequest, GetConnectionsResponse> {
            serializer = GetConnectionsOperationSerializer()
            deserializer = GetConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConnections"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetConnectionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetConnections-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the LIVE policy for a core network.
     */
    override suspend fun getCoreNetwork(input: GetCoreNetworkRequest): GetCoreNetworkResponse {
        val op = SdkHttpOperation.build<GetCoreNetworkRequest, GetCoreNetworkResponse> {
            serializer = GetCoreNetworkOperationSerializer()
            deserializer = GetCoreNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCoreNetwork"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCoreNetworkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCoreNetwork-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a core network change event.
     */
    override suspend fun getCoreNetworkChangeEvents(input: GetCoreNetworkChangeEventsRequest): GetCoreNetworkChangeEventsResponse {
        val op = SdkHttpOperation.build<GetCoreNetworkChangeEventsRequest, GetCoreNetworkChangeEventsResponse> {
            serializer = GetCoreNetworkChangeEventsOperationSerializer()
            deserializer = GetCoreNetworkChangeEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCoreNetworkChangeEvents"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCoreNetworkChangeEventsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCoreNetworkChangeEvents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a change set between the LIVE core network policy and a submitted policy.
     */
    override suspend fun getCoreNetworkChangeSet(input: GetCoreNetworkChangeSetRequest): GetCoreNetworkChangeSetResponse {
        val op = SdkHttpOperation.build<GetCoreNetworkChangeSetRequest, GetCoreNetworkChangeSetResponse> {
            serializer = GetCoreNetworkChangeSetOperationSerializer()
            deserializer = GetCoreNetworkChangeSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCoreNetworkChangeSet"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCoreNetworkChangeSetRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCoreNetworkChangeSet-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns details about a core network policy. You can get details about your current live policy or any previous policy version.
     */
    override suspend fun getCoreNetworkPolicy(input: GetCoreNetworkPolicyRequest): GetCoreNetworkPolicyResponse {
        val op = SdkHttpOperation.build<GetCoreNetworkPolicyRequest, GetCoreNetworkPolicyResponse> {
            serializer = GetCoreNetworkPolicyOperationSerializer()
            deserializer = GetCoreNetworkPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCoreNetworkPolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCoreNetworkPolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCoreNetworkPolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the association information for customer gateways that are associated with devices and links in your global network.
     */
    override suspend fun getCustomerGatewayAssociations(input: GetCustomerGatewayAssociationsRequest): GetCustomerGatewayAssociationsResponse {
        val op = SdkHttpOperation.build<GetCustomerGatewayAssociationsRequest, GetCustomerGatewayAssociationsResponse> {
            serializer = GetCustomerGatewayAssociationsOperationSerializer()
            deserializer = GetCustomerGatewayAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCustomerGatewayAssociations"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCustomerGatewayAssociationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCustomerGatewayAssociations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about one or more of your devices in a global network.
     */
    override suspend fun getDevices(input: GetDevicesRequest): GetDevicesResponse {
        val op = SdkHttpOperation.build<GetDevicesRequest, GetDevicesResponse> {
            serializer = GetDevicesOperationSerializer()
            deserializer = GetDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDevices"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetDevicesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDevices-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     */
    override suspend fun getLinkAssociations(input: GetLinkAssociationsRequest): GetLinkAssociationsResponse {
        val op = SdkHttpOperation.build<GetLinkAssociationsRequest, GetLinkAssociationsResponse> {
            serializer = GetLinkAssociationsOperationSerializer()
            deserializer = GetLinkAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLinkAssociations"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetLinkAssociationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetLinkAssociations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about one or more links in a specified global network.
     *
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.
     */
    override suspend fun getLinks(input: GetLinksRequest): GetLinksResponse {
        val op = SdkHttpOperation.build<GetLinksRequest, GetLinksResponse> {
            serializer = GetLinksOperationSerializer()
            deserializer = GetLinksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLinks"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetLinksRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetLinks-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the count of network resources, by resource type, for the specified global network.
     */
    override suspend fun getNetworkResourceCounts(input: GetNetworkResourceCountsRequest): GetNetworkResourceCountsResponse {
        val op = SdkHttpOperation.build<GetNetworkResourceCountsRequest, GetNetworkResourceCountsResponse> {
            serializer = GetNetworkResourceCountsOperationSerializer()
            deserializer = GetNetworkResourceCountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkResourceCounts"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetNetworkResourceCountsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetNetworkResourceCounts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the network resource relationships for the specified global network.
     */
    override suspend fun getNetworkResourceRelationships(input: GetNetworkResourceRelationshipsRequest): GetNetworkResourceRelationshipsResponse {
        val op = SdkHttpOperation.build<GetNetworkResourceRelationshipsRequest, GetNetworkResourceRelationshipsResponse> {
            serializer = GetNetworkResourceRelationshipsOperationSerializer()
            deserializer = GetNetworkResourceRelationshipsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkResourceRelationships"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetNetworkResourceRelationshipsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetNetworkResourceRelationships-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the network resources for the specified global network.
     *
     * The results include information from the corresponding Describe call for the resource, minus any sensitive information such as pre-shared keys.
     */
    override suspend fun getNetworkResources(input: GetNetworkResourcesRequest): GetNetworkResourcesResponse {
        val op = SdkHttpOperation.build<GetNetworkResourcesRequest, GetNetworkResourcesResponse> {
            serializer = GetNetworkResourcesOperationSerializer()
            deserializer = GetNetworkResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkResources"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetNetworkResourcesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetNetworkResources-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the network routes of the specified global network.
     */
    override suspend fun getNetworkRoutes(input: GetNetworkRoutesRequest): GetNetworkRoutesResponse {
        val op = SdkHttpOperation.build<GetNetworkRoutesRequest, GetNetworkRoutesResponse> {
            serializer = GetNetworkRoutesOperationSerializer()
            deserializer = GetNetworkRoutesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkRoutes"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetNetworkRoutesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetNetworkRoutes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the network telemetry of the specified global network.
     */
    override suspend fun getNetworkTelemetry(input: GetNetworkTelemetryRequest): GetNetworkTelemetryResponse {
        val op = SdkHttpOperation.build<GetNetworkTelemetryRequest, GetNetworkTelemetryResponse> {
            serializer = GetNetworkTelemetryOperationSerializer()
            deserializer = GetNetworkTelemetryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkTelemetry"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetNetworkTelemetryRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetNetworkTelemetry-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a resource policy.
     */
    override suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse {
        val op = SdkHttpOperation.build<GetResourcePolicyRequest, GetResourcePolicyResponse> {
            serializer = GetResourcePolicyOperationSerializer()
            deserializer = GetResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResourcePolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetResourcePolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetResourcePolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about the specified route analysis.
     */
    override suspend fun getRouteAnalysis(input: GetRouteAnalysisRequest): GetRouteAnalysisResponse {
        val op = SdkHttpOperation.build<GetRouteAnalysisRequest, GetRouteAnalysisResponse> {
            serializer = GetRouteAnalysisOperationSerializer()
            deserializer = GetRouteAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRouteAnalysis"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetRouteAnalysisRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetRouteAnalysis-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a site-to-site VPN attachment.
     */
    override suspend fun getSiteToSiteVpnAttachment(input: GetSiteToSiteVpnAttachmentRequest): GetSiteToSiteVpnAttachmentResponse {
        val op = SdkHttpOperation.build<GetSiteToSiteVpnAttachmentRequest, GetSiteToSiteVpnAttachmentResponse> {
            serializer = GetSiteToSiteVpnAttachmentOperationSerializer()
            deserializer = GetSiteToSiteVpnAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSiteToSiteVpnAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSiteToSiteVpnAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSiteToSiteVpnAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about one or more of your sites in a global network.
     */
    override suspend fun getSites(input: GetSitesRequest): GetSitesResponse {
        val op = SdkHttpOperation.build<GetSitesRequest, GetSitesResponse> {
            serializer = GetSitesOperationSerializer()
            deserializer = GetSitesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSites"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSitesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSites-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     */
    override suspend fun getTransitGatewayConnectPeerAssociations(input: GetTransitGatewayConnectPeerAssociationsRequest): GetTransitGatewayConnectPeerAssociationsResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayConnectPeerAssociationsRequest, GetTransitGatewayConnectPeerAssociationsResponse> {
            serializer = GetTransitGatewayConnectPeerAssociationsOperationSerializer()
            deserializer = GetTransitGatewayConnectPeerAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTransitGatewayConnectPeerAssociations"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTransitGatewayConnectPeerAssociationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTransitGatewayConnectPeerAssociations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a transit gateway peer.
     */
    override suspend fun getTransitGatewayPeering(input: GetTransitGatewayPeeringRequest): GetTransitGatewayPeeringResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayPeeringRequest, GetTransitGatewayPeeringResponse> {
            serializer = GetTransitGatewayPeeringOperationSerializer()
            deserializer = GetTransitGatewayPeeringOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTransitGatewayPeering"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTransitGatewayPeeringRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTransitGatewayPeering-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about the transit gateway registrations in a specified global network.
     */
    override suspend fun getTransitGatewayRegistrations(input: GetTransitGatewayRegistrationsRequest): GetTransitGatewayRegistrationsResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayRegistrationsRequest, GetTransitGatewayRegistrationsResponse> {
            serializer = GetTransitGatewayRegistrationsOperationSerializer()
            deserializer = GetTransitGatewayRegistrationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTransitGatewayRegistrations"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTransitGatewayRegistrationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTransitGatewayRegistrations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a transit gateway route table attachment.
     */
    override suspend fun getTransitGatewayRouteTableAttachment(input: GetTransitGatewayRouteTableAttachmentRequest): GetTransitGatewayRouteTableAttachmentResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayRouteTableAttachmentRequest, GetTransitGatewayRouteTableAttachmentResponse> {
            serializer = GetTransitGatewayRouteTableAttachmentOperationSerializer()
            deserializer = GetTransitGatewayRouteTableAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTransitGatewayRouteTableAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTransitGatewayRouteTableAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTransitGatewayRouteTableAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a VPC attachment.
     */
    override suspend fun getVpcAttachment(input: GetVpcAttachmentRequest): GetVpcAttachmentResponse {
        val op = SdkHttpOperation.build<GetVpcAttachmentRequest, GetVpcAttachmentResponse> {
            serializer = GetVpcAttachmentOperationSerializer()
            deserializer = GetVpcAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVpcAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetVpcAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetVpcAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of core network attachments.
     */
    override suspend fun listAttachments(input: ListAttachmentsRequest): ListAttachmentsResponse {
        val op = SdkHttpOperation.build<ListAttachmentsRequest, ListAttachmentsResponse> {
            serializer = ListAttachmentsOperationSerializer()
            deserializer = ListAttachmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAttachments"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListAttachmentsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListAttachments-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of core network Connect peers.
     */
    override suspend fun listConnectPeers(input: ListConnectPeersRequest): ListConnectPeersResponse {
        val op = SdkHttpOperation.build<ListConnectPeersRequest, ListConnectPeersResponse> {
            serializer = ListConnectPeersOperationSerializer()
            deserializer = ListConnectPeersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConnectPeers"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListConnectPeersRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListConnectPeers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of core network policy versions.
     */
    override suspend fun listCoreNetworkPolicyVersions(input: ListCoreNetworkPolicyVersionsRequest): ListCoreNetworkPolicyVersionsResponse {
        val op = SdkHttpOperation.build<ListCoreNetworkPolicyVersionsRequest, ListCoreNetworkPolicyVersionsResponse> {
            serializer = ListCoreNetworkPolicyVersionsOperationSerializer()
            deserializer = ListCoreNetworkPolicyVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCoreNetworkPolicyVersions"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCoreNetworkPolicyVersionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCoreNetworkPolicyVersions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of owned and shared core networks.
     */
    override suspend fun listCoreNetworks(input: ListCoreNetworksRequest): ListCoreNetworksResponse {
        val op = SdkHttpOperation.build<ListCoreNetworksRequest, ListCoreNetworksResponse> {
            serializer = ListCoreNetworksOperationSerializer()
            deserializer = ListCoreNetworksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCoreNetworks"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCoreNetworksRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCoreNetworks-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services Organization.
     */
    override suspend fun listOrganizationServiceAccessStatus(input: ListOrganizationServiceAccessStatusRequest): ListOrganizationServiceAccessStatusResponse {
        val op = SdkHttpOperation.build<ListOrganizationServiceAccessStatusRequest, ListOrganizationServiceAccessStatusResponse> {
            serializer = ListOrganizationServiceAccessStatusOperationSerializer()
            deserializer = ListOrganizationServiceAccessStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOrganizationServiceAccessStatus"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListOrganizationServiceAccessStatusRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListOrganizationServiceAccessStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the peerings for a core network.
     */
    override suspend fun listPeerings(input: ListPeeringsRequest): ListPeeringsResponse {
        val op = SdkHttpOperation.build<ListPeeringsRequest, ListPeeringsResponse> {
            serializer = ListPeeringsOperationSerializer()
            deserializer = ListPeeringsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPeerings"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListPeeringsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListPeerings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the tags for a specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and the submitted policy.
     */
    override suspend fun putCoreNetworkPolicy(input: PutCoreNetworkPolicyRequest): PutCoreNetworkPolicyResponse {
        val op = SdkHttpOperation.build<PutCoreNetworkPolicyRequest, PutCoreNetworkPolicyResponse> {
            serializer = PutCoreNetworkPolicyOperationSerializer()
            deserializer = PutCoreNetworkPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutCoreNetworkPolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutCoreNetworkPolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutCoreNetworkPolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates or updates a resource policy.
     */
    override suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse {
        val op = SdkHttpOperation.build<PutResourcePolicyRequest, PutResourcePolicyResponse> {
            serializer = PutResourcePolicyOperationSerializer()
            deserializer = PutResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutResourcePolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutResourcePolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutResourcePolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Registers a transit gateway in your global network. The transit gateway can be in any Amazon Web Services Region, but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one global network.
     */
    override suspend fun registerTransitGateway(input: RegisterTransitGatewayRequest): RegisterTransitGatewayResponse {
        val op = SdkHttpOperation.build<RegisterTransitGatewayRequest, RegisterTransitGatewayResponse> {
            serializer = RegisterTransitGatewayOperationSerializer()
            deserializer = RegisterTransitGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterTransitGateway"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RegisterTransitGatewayRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RegisterTransitGateway-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Rejects a core network attachment request.
     */
    override suspend fun rejectAttachment(input: RejectAttachmentRequest): RejectAttachmentResponse {
        val op = SdkHttpOperation.build<RejectAttachmentRequest, RejectAttachmentResponse> {
            serializer = RejectAttachmentOperationSerializer()
            deserializer = RejectAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RejectAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RejectAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and restored policy.
     */
    override suspend fun restoreCoreNetworkPolicyVersion(input: RestoreCoreNetworkPolicyVersionRequest): RestoreCoreNetworkPolicyVersionResponse {
        val op = SdkHttpOperation.build<RestoreCoreNetworkPolicyVersionRequest, RestoreCoreNetworkPolicyVersionResponse> {
            serializer = RestoreCoreNetworkPolicyVersionOperationSerializer()
            deserializer = RestoreCoreNetworkPolicyVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreCoreNetworkPolicyVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RestoreCoreNetworkPolicyVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RestoreCoreNetworkPolicyVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables the Network Manager service for an Amazon Web Services Organization. This can only be called by a management account within the organization.
     */
    override suspend fun startOrganizationServiceAccessUpdate(input: StartOrganizationServiceAccessUpdateRequest): StartOrganizationServiceAccessUpdateResponse {
        val op = SdkHttpOperation.build<StartOrganizationServiceAccessUpdateRequest, StartOrganizationServiceAccessUpdateResponse> {
            serializer = StartOrganizationServiceAccessUpdateOperationSerializer()
            deserializer = StartOrganizationServiceAccessUpdateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartOrganizationServiceAccessUpdate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartOrganizationServiceAccessUpdateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartOrganizationServiceAccessUpdate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts analyzing the routing path between the specified source and destination. For more information, see [Route Analyzer](https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html).
     */
    override suspend fun startRouteAnalysis(input: StartRouteAnalysisRequest): StartRouteAnalysisResponse {
        val op = SdkHttpOperation.build<StartRouteAnalysisRequest, StartRouteAnalysisResponse> {
            serializer = StartRouteAnalysisOperationSerializer()
            deserializer = StartRouteAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartRouteAnalysis"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartRouteAnalysisRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartRouteAnalysis-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Tags a specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes tags from a specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the information for an existing connection. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateConnection(input: UpdateConnectionRequest): UpdateConnectionResponse {
        val op = SdkHttpOperation.build<UpdateConnectionRequest, UpdateConnectionResponse> {
            serializer = UpdateConnectionOperationSerializer()
            deserializer = UpdateConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the description of a core network.
     */
    override suspend fun updateCoreNetwork(input: UpdateCoreNetworkRequest): UpdateCoreNetworkResponse {
        val op = SdkHttpOperation.build<UpdateCoreNetworkRequest, UpdateCoreNetworkResponse> {
            serializer = UpdateCoreNetworkOperationSerializer()
            deserializer = UpdateCoreNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCoreNetwork"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateCoreNetworkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateCoreNetwork-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateDevice(input: UpdateDeviceRequest): UpdateDeviceResponse {
        val op = SdkHttpOperation.build<UpdateDeviceRequest, UpdateDeviceResponse> {
            serializer = UpdateDeviceOperationSerializer()
            deserializer = UpdateDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDevice"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateDeviceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDevice-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateGlobalNetwork(input: UpdateGlobalNetworkRequest): UpdateGlobalNetworkResponse {
        val op = SdkHttpOperation.build<UpdateGlobalNetworkRequest, UpdateGlobalNetworkResponse> {
            serializer = UpdateGlobalNetworkOperationSerializer()
            deserializer = UpdateGlobalNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGlobalNetwork"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateGlobalNetworkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateGlobalNetwork-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateLink(input: UpdateLinkRequest): UpdateLinkResponse {
        val op = SdkHttpOperation.build<UpdateLinkRequest, UpdateLinkResponse> {
            serializer = UpdateLinkOperationSerializer()
            deserializer = UpdateLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLink"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateLinkRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateLink-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the resource metadata for the specified global network.
     */
    override suspend fun updateNetworkResourceMetadata(input: UpdateNetworkResourceMetadataRequest): UpdateNetworkResourceMetadataResponse {
        val op = SdkHttpOperation.build<UpdateNetworkResourceMetadataRequest, UpdateNetworkResourceMetadataResponse> {
            serializer = UpdateNetworkResourceMetadataOperationSerializer()
            deserializer = UpdateNetworkResourceMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNetworkResourceMetadata"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateNetworkResourceMetadataRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateNetworkResourceMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse {
        val op = SdkHttpOperation.build<UpdateSiteRequest, UpdateSiteResponse> {
            serializer = UpdateSiteOperationSerializer()
            deserializer = UpdateSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSite"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateSiteRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateSite-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a VPC attachment.
     */
    override suspend fun updateVpcAttachment(input: UpdateVpcAttachmentRequest): UpdateVpcAttachmentResponse {
        val op = SdkHttpOperation.build<UpdateVpcAttachmentRequest, UpdateVpcAttachmentResponse> {
            serializer = UpdateVpcAttachmentOperationSerializer()
            deserializer = UpdateVpcAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVpcAttachment"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateVpcAttachmentRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "networkmanager"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateVpcAttachment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "networkmanager")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
