// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.transform

import aws.sdk.kotlin.services.networkmanager.model.GetNetworkRoutesRequest
import aws.sdk.kotlin.services.networkmanager.model.RouteState
import aws.sdk.kotlin.services.networkmanager.model.RouteTableIdentifier
import aws.sdk.kotlin.services.networkmanager.model.RouteType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetNetworkRoutesOperationSerializer: HttpSerialize<GetNetworkRoutesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetNetworkRoutesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "global-networks",
                "${input.globalNetworkId}".encodeLabel(),
                "network-routes",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeGetNetworkRoutesOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetNetworkRoutesOperationBody(context: ExecutionContext, input: GetNetworkRoutesRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESTINATIONFILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("DestinationFilters"))
    val DESTINATIONFILTERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val EXACTCIDRMATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ExactCidrMatches"))
    val LONGESTPREFIXMATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LongestPrefixMatches"))
    val PREFIXLISTIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PrefixListIds"))
    val ROUTETABLEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RouteTableIdentifier"))
    val STATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("States"))
    val SUBNETOFMATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SubnetOfMatches"))
    val SUPERNETOFMATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SupernetOfMatches"))
    val TYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Types"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATIONFILTERS_DESCRIPTOR)
        field(EXACTCIDRMATCHES_DESCRIPTOR)
        field(LONGESTPREFIXMATCHES_DESCRIPTOR)
        field(PREFIXLISTIDS_DESCRIPTOR)
        field(ROUTETABLEIDENTIFIER_DESCRIPTOR)
        field(STATES_DESCRIPTOR)
        field(SUBNETOFMATCHES_DESCRIPTOR)
        field(SUPERNETOFMATCHES_DESCRIPTOR)
        field(TYPES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.destinationFilters != null) {
            mapField(DESTINATIONFILTERS_DESCRIPTOR) {
                input.destinationFilters.forEach { (key, value) ->
                    listEntry(key, DESTINATIONFILTERS_C0_DESCRIPTOR) {
                        for (el1 in value) {
                            serializeString(el1)
                        }
                    }
                }
            }
        }
        if (input.exactCidrMatches != null) {
            listField(EXACTCIDRMATCHES_DESCRIPTOR) {
                for (el0 in input.exactCidrMatches) {
                    serializeString(el0)
                }
            }
        }
        if (input.longestPrefixMatches != null) {
            listField(LONGESTPREFIXMATCHES_DESCRIPTOR) {
                for (el0 in input.longestPrefixMatches) {
                    serializeString(el0)
                }
            }
        }
        if (input.prefixListIds != null) {
            listField(PREFIXLISTIDS_DESCRIPTOR) {
                for (el0 in input.prefixListIds) {
                    serializeString(el0)
                }
            }
        }
        input.routeTableIdentifier?.let { field(ROUTETABLEIDENTIFIER_DESCRIPTOR, it, ::serializeRouteTableIdentifierDocument) }
        if (input.states != null) {
            listField(STATES_DESCRIPTOR) {
                for (el0 in input.states) {
                    serializeString(el0.value)
                }
            }
        }
        if (input.subnetOfMatches != null) {
            listField(SUBNETOFMATCHES_DESCRIPTOR) {
                for (el0 in input.subnetOfMatches) {
                    serializeString(el0)
                }
            }
        }
        if (input.supernetOfMatches != null) {
            listField(SUPERNETOFMATCHES_DESCRIPTOR) {
                for (el0 in input.supernetOfMatches) {
                    serializeString(el0)
                }
            }
        }
        if (input.types != null) {
            listField(TYPES_DESCRIPTOR) {
                for (el0 in input.types) {
                    serializeString(el0.value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
