// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkRoutesResponse
import aws.sdk.kotlin.services.networkmanager.model.NetworkManagerException
import aws.sdk.kotlin.services.networkmanager.model.NetworkRoute
import aws.sdk.kotlin.services.networkmanager.model.RouteTableType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetNetworkRoutesOperationDeserializer: HttpDeserialize<GetNetworkRoutesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetNetworkRoutesResponse {
        if (!response.status.isSuccess()) {
            throwGetNetworkRoutesError(context, response)
        }
        val builder = GetNetworkRoutesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetNetworkRoutesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetNetworkRoutesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkManagerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> NetworkManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetNetworkRoutesOperationBody(builder: GetNetworkRoutesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CORENETWORKSEGMENTEDGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CoreNetworkSegmentEdge"))
    val NETWORKROUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NetworkRoutes"))
    val ROUTETABLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RouteTableArn"))
    val ROUTETABLETIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("RouteTableTimestamp"))
    val ROUTETABLETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RouteTableType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CORENETWORKSEGMENTEDGE_DESCRIPTOR)
        field(NETWORKROUTES_DESCRIPTOR)
        field(ROUTETABLEARN_DESCRIPTOR)
        field(ROUTETABLETIMESTAMP_DESCRIPTOR)
        field(ROUTETABLETYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CORENETWORKSEGMENTEDGE_DESCRIPTOR.index -> builder.coreNetworkSegmentEdge = deserializeCoreNetworkSegmentEdgeIdentifierDocument(deserializer)
                NETWORKROUTES_DESCRIPTOR.index -> builder.networkRoutes =
                    deserializer.deserializeList(NETWORKROUTES_DESCRIPTOR) {
                        val col0 = mutableListOf<NetworkRoute>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNetworkRouteDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROUTETABLEARN_DESCRIPTOR.index -> builder.routeTableArn = deserializeString()
                ROUTETABLETIMESTAMP_DESCRIPTOR.index -> builder.routeTableTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                ROUTETABLETYPE_DESCRIPTOR.index -> builder.routeTableType = deserializeString().let { RouteTableType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
