// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.networkmanager.model.CustomerGatewayAssociation
import aws.sdk.kotlin.services.networkmanager.model.DisassociateCustomerGatewayResponse
import aws.sdk.kotlin.services.networkmanager.model.NetworkManagerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DisassociateCustomerGatewayOperationDeserializer: HttpDeserialize<DisassociateCustomerGatewayResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisassociateCustomerGatewayResponse {
        if (!response.status.isSuccess()) {
            throwDisassociateCustomerGatewayError(context, response)
        }
        val builder = DisassociateCustomerGatewayResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDisassociateCustomerGatewayOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDisassociateCustomerGatewayError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkManagerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> NetworkManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDisassociateCustomerGatewayOperationBody(builder: DisassociateCustomerGatewayResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMERGATEWAYASSOCIATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CustomerGatewayAssociation"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMERGATEWAYASSOCIATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMERGATEWAYASSOCIATION_DESCRIPTOR.index -> builder.customerGatewayAssociation = deserializeCustomerGatewayAssociationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
