// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.model



/**
 * Describes the status of an analysis at completion.
 */
public class RouteAnalysisCompletion private constructor(builder: Builder) {
    /**
     * The reason code. Available only if a connection is not found.
     * + `BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND` - Found a black hole route with the destination CIDR block.
     * + `CYCLIC_PATH_DETECTED` - Found the same resource multiple times while traversing the path.
     * + `INACTIVE_ROUTE_FOR_DESTINATION_FOUND` - Found an inactive route with the destination CIDR block.
     * + `MAX_HOPS_EXCEEDED` - Analysis exceeded 64 hops without finding the destination.
     * + `ROUTE_NOT_FOUND` - Cannot find a route table with the destination CIDR block.
     * + `TGW_ATTACH_ARN_NO_MATCH` - Found an attachment, but not with the correct destination ARN.
     * + `TGW_ATTACH_NOT_FOUND` - Cannot find an attachment.
     * + `TGW_ATTACH_NOT_IN_TGW` - Found an attachment, but not to the correct transit gateway.
     * + `TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND` - The state of the route table association is not associated.
     */
    public val reasonCode: aws.sdk.kotlin.services.networkmanager.model.RouteAnalysisCompletionReasonCode? = builder.reasonCode
    /**
     * Additional information about the path. Available only if a connection is not found.
     */
    public val reasonContext: Map<String, String>? = builder.reasonContext
    /**
     * The result of the analysis. If the status is `NOT_CONNECTED`, check the reason code.
     */
    public val resultCode: aws.sdk.kotlin.services.networkmanager.model.RouteAnalysisCompletionResultCode? = builder.resultCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmanager.model.RouteAnalysisCompletion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RouteAnalysisCompletion(")
        append("reasonCode=$reasonCode,")
        append("reasonContext=$reasonContext,")
        append("resultCode=$resultCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = reasonCode?.hashCode() ?: 0
        result = 31 * result + (reasonContext?.hashCode() ?: 0)
        result = 31 * result + (resultCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RouteAnalysisCompletion

        if (reasonCode != other.reasonCode) return false
        if (reasonContext != other.reasonContext) return false
        if (resultCode != other.resultCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmanager.model.RouteAnalysisCompletion = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The reason code. Available only if a connection is not found.
         * + `BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND` - Found a black hole route with the destination CIDR block.
         * + `CYCLIC_PATH_DETECTED` - Found the same resource multiple times while traversing the path.
         * + `INACTIVE_ROUTE_FOR_DESTINATION_FOUND` - Found an inactive route with the destination CIDR block.
         * + `MAX_HOPS_EXCEEDED` - Analysis exceeded 64 hops without finding the destination.
         * + `ROUTE_NOT_FOUND` - Cannot find a route table with the destination CIDR block.
         * + `TGW_ATTACH_ARN_NO_MATCH` - Found an attachment, but not with the correct destination ARN.
         * + `TGW_ATTACH_NOT_FOUND` - Cannot find an attachment.
         * + `TGW_ATTACH_NOT_IN_TGW` - Found an attachment, but not to the correct transit gateway.
         * + `TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND` - The state of the route table association is not associated.
         */
        public var reasonCode: aws.sdk.kotlin.services.networkmanager.model.RouteAnalysisCompletionReasonCode? = null
        /**
         * Additional information about the path. Available only if a connection is not found.
         */
        public var reasonContext: Map<String, String>? = null
        /**
         * The result of the analysis. If the status is `NOT_CONNECTED`, check the reason code.
         */
        public var resultCode: aws.sdk.kotlin.services.networkmanager.model.RouteAnalysisCompletionResultCode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmanager.model.RouteAnalysisCompletion) : this() {
            this.reasonCode = x.reasonCode
            this.reasonContext = x.reasonContext
            this.resultCode = x.resultCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmanager.model.RouteAnalysisCompletion = RouteAnalysisCompletion(this)
    }
}
