// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a network resource.
 */
public class NetworkResource private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Web Services Region.
     */
    public val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * The ID of a core network.
     */
    public val coreNetworkId: kotlin.String? = builder.coreNetworkId
    /**
     * Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.
     */
    public val definition: kotlin.String? = builder.definition
    /**
     * The time that the resource definition was retrieved.
     */
    public val definitionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.definitionTimestamp
    /**
     * The resource metadata.
     */
    public val metadata: Map<String, String>? = builder.metadata
    /**
     * The ARN of the gateway.
     */
    public val registeredGatewayArn: kotlin.String? = builder.registeredGatewayArn
    /**
     * The ARN of the resource.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The ID of the resource.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The resource type.
     *
     * The following are the supported resource types for Direct Connect:
     * + `dxcon`
     * + `dx-gateway`
     * + `dx-vif`
     *
     * The following are the supported resource types for Network Manager:
     * + `connection`
     * + `device`
     * + `link`
     * + `site`
     *
     * The following are the supported resource types for Amazon VPC:
     * + `customer-gateway`
     * + `transit-gateway`
     * + `transit-gateway-attachment`
     * + `transit-gateway-connect-peer`
     * + `transit-gateway-route-table`
     * + `vpn-connection`
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The tags.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmanager.model.NetworkResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkResource(")
        append("accountId=$accountId,")
        append("awsRegion=$awsRegion,")
        append("coreNetworkId=$coreNetworkId,")
        append("definition=$definition,")
        append("definitionTimestamp=$definitionTimestamp,")
        append("metadata=$metadata,")
        append("registeredGatewayArn=$registeredGatewayArn,")
        append("resourceArn=$resourceArn,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (coreNetworkId?.hashCode() ?: 0)
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (definitionTimestamp?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (registeredGatewayArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkResource

        if (accountId != other.accountId) return false
        if (awsRegion != other.awsRegion) return false
        if (coreNetworkId != other.coreNetworkId) return false
        if (definition != other.definition) return false
        if (definitionTimestamp != other.definitionTimestamp) return false
        if (metadata != other.metadata) return false
        if (registeredGatewayArn != other.registeredGatewayArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmanager.model.NetworkResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Web Services Region.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * The ID of a core network.
         */
        public var coreNetworkId: kotlin.String? = null
        /**
         * Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.
         */
        public var definition: kotlin.String? = null
        /**
         * The time that the resource definition was retrieved.
         */
        public var definitionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The resource metadata.
         */
        public var metadata: Map<String, String>? = null
        /**
         * The ARN of the gateway.
         */
        public var registeredGatewayArn: kotlin.String? = null
        /**
         * The ARN of the resource.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The ID of the resource.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The resource type.
         *
         * The following are the supported resource types for Direct Connect:
         * + `dxcon`
         * + `dx-gateway`
         * + `dx-vif`
         *
         * The following are the supported resource types for Network Manager:
         * + `connection`
         * + `device`
         * + `link`
         * + `site`
         *
         * The following are the supported resource types for Amazon VPC:
         * + `customer-gateway`
         * + `transit-gateway`
         * + `transit-gateway-attachment`
         * + `transit-gateway-connect-peer`
         * + `transit-gateway-route-table`
         * + `vpn-connection`
         */
        public var resourceType: kotlin.String? = null
        /**
         * The tags.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmanager.model.NetworkResource) : this() {
            this.accountId = x.accountId
            this.awsRegion = x.awsRegion
            this.coreNetworkId = x.coreNetworkId
            this.definition = x.definition
            this.definitionTimestamp = x.definitionTimestamp
            this.metadata = x.metadata
            this.registeredGatewayArn = x.registeredGatewayArn
            this.resourceArn = x.resourceArn
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmanager.model.NetworkResource = NetworkResource(this)
    }
}
