// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a global network. This is a single private network acting as a high-level container for your network objects, including an Amazon Web Services-managed Core Network.
 */
public class GlobalNetwork private constructor(builder: Builder) {
    /**
     * The date and time that the global network was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The description of the global network.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the global network.
     */
    public val globalNetworkArn: kotlin.String? = builder.globalNetworkArn
    /**
     * The ID of the global network.
     */
    public val globalNetworkId: kotlin.String? = builder.globalNetworkId
    /**
     * The state of the global network.
     */
    public val state: aws.sdk.kotlin.services.networkmanager.model.GlobalNetworkState? = builder.state
    /**
     * The tags for the global network.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmanager.model.GlobalNetwork = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalNetwork(")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("globalNetworkArn=$globalNetworkArn,")
        append("globalNetworkId=$globalNetworkId,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (globalNetworkArn?.hashCode() ?: 0)
        result = 31 * result + (globalNetworkId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalNetwork

        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (globalNetworkArn != other.globalNetworkArn) return false
        if (globalNetworkId != other.globalNetworkId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmanager.model.GlobalNetwork = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the global network was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the global network.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the global network.
         */
        public var globalNetworkArn: kotlin.String? = null
        /**
         * The ID of the global network.
         */
        public var globalNetworkId: kotlin.String? = null
        /**
         * The state of the global network.
         */
        public var state: aws.sdk.kotlin.services.networkmanager.model.GlobalNetworkState? = null
        /**
         * The tags for the global network.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmanager.model.GlobalNetwork) : this() {
            this.createdAt = x.createdAt
            this.description = x.description
            this.globalNetworkArn = x.globalNetworkArn
            this.globalNetworkId = x.globalNetworkId
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmanager.model.GlobalNetwork = GlobalNetwork(this)
    }
}
