// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.model



public class GetNetworkResourcesRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Web Services Region.
     */
    public val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * The ID of a core network.
     */
    public val coreNetworkId: kotlin.String? = builder.coreNetworkId
    /**
     * The ID of the global network.
     */
    public val globalNetworkId: kotlin.String? = requireNotNull(builder.globalNetworkId) { "A non-null value must be provided for globalNetworkId" }
    /**
     * The maximum number of results to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARN of the gateway.
     */
    public val registeredGatewayArn: kotlin.String? = builder.registeredGatewayArn
    /**
     * The ARN of the resource.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The resource type.
     *
     * The following are the supported resource types for Direct Connect:
     * + `dxcon` - The definition model is [Connection](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html).
     * + `dx-gateway` - The definition model is [DirectConnectGateway](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html).
     * + `dx-vif` - The definition model is [VirtualInterface](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html).
     *
     * The following are the supported resource types for Network Manager:
     * + `connection` - The definition model is [Connection](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html).
     * + `device` - The definition model is [Device](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html).
     * + `link` - The definition model is [Link](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html).
     * + `site` - The definition model is [Site](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html).
     *
     * The following are the supported resource types for Amazon VPC:
     * + `customer-gateway` - The definition model is [CustomerGateway](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html).
     * + `transit-gateway` - The definition model is [TransitGateway](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html).
     * + `transit-gateway-attachment` - The definition model is [TransitGatewayAttachment](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html).
     * + `transit-gateway-connect-peer` - The definition model is [TransitGatewayConnectPeer](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html).
     * + `transit-gateway-route-table` - The definition model is [TransitGatewayRouteTable](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html).
     * + `vpn-connection` - The definition model is [VpnConnection](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html).
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetNetworkResourcesRequest(")
        append("accountId=$accountId,")
        append("awsRegion=$awsRegion,")
        append("coreNetworkId=$coreNetworkId,")
        append("globalNetworkId=$globalNetworkId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("registeredGatewayArn=$registeredGatewayArn,")
        append("resourceArn=$resourceArn,")
        append("resourceType=$resourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (coreNetworkId?.hashCode() ?: 0)
        result = 31 * result + (globalNetworkId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (registeredGatewayArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetNetworkResourcesRequest

        if (accountId != other.accountId) return false
        if (awsRegion != other.awsRegion) return false
        if (coreNetworkId != other.coreNetworkId) return false
        if (globalNetworkId != other.globalNetworkId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (registeredGatewayArn != other.registeredGatewayArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourcesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Web Services Region.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * The ID of a core network.
         */
        public var coreNetworkId: kotlin.String? = null
        /**
         * The ID of the global network.
         */
        public var globalNetworkId: kotlin.String? = null
        /**
         * The maximum number of results to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ARN of the gateway.
         */
        public var registeredGatewayArn: kotlin.String? = null
        /**
         * The ARN of the resource.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The resource type.
         *
         * The following are the supported resource types for Direct Connect:
         * + `dxcon` - The definition model is [Connection](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html).
         * + `dx-gateway` - The definition model is [DirectConnectGateway](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html).
         * + `dx-vif` - The definition model is [VirtualInterface](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html).
         *
         * The following are the supported resource types for Network Manager:
         * + `connection` - The definition model is [Connection](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html).
         * + `device` - The definition model is [Device](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html).
         * + `link` - The definition model is [Link](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html).
         * + `site` - The definition model is [Site](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html).
         *
         * The following are the supported resource types for Amazon VPC:
         * + `customer-gateway` - The definition model is [CustomerGateway](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html).
         * + `transit-gateway` - The definition model is [TransitGateway](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html).
         * + `transit-gateway-attachment` - The definition model is [TransitGatewayAttachment](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html).
         * + `transit-gateway-connect-peer` - The definition model is [TransitGatewayConnectPeer](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html).
         * + `transit-gateway-route-table` - The definition model is [TransitGatewayRouteTable](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html).
         * + `vpn-connection` - The definition model is [VpnConnection](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html).
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourcesRequest) : this() {
            this.accountId = x.accountId
            this.awsRegion = x.awsRegion
            this.coreNetworkId = x.coreNetworkId
            this.globalNetworkId = x.globalNetworkId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.registeredGatewayArn = x.registeredGatewayArn
            this.resourceArn = x.resourceArn
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourcesRequest = GetNetworkResourcesRequest(this)
    }
}
