// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.model



public class CreateDeviceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.
     */
    public val awsLocation: aws.sdk.kotlin.services.networkmanager.model.AwsLocation? = builder.awsLocation
    /**
     * A description of the device.
     *
     * Constraints: Maximum length of 256 characters.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the global network.
     */
    public val globalNetworkId: kotlin.String? = requireNotNull(builder.globalNetworkId) { "A non-null value must be provided for globalNetworkId" }
    /**
     * The location of the device.
     */
    public val location: aws.sdk.kotlin.services.networkmanager.model.Location? = builder.location
    /**
     * The model of the device.
     *
     * Constraints: Maximum length of 128 characters.
     */
    public val model: kotlin.String? = builder.model
    /**
     * The serial number of the device.
     *
     * Constraints: Maximum length of 128 characters.
     */
    public val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * The ID of the site.
     */
    public val siteId: kotlin.String? = builder.siteId
    /**
     * The tags to apply to the resource during creation.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The type of the device.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The vendor of the device.
     *
     * Constraints: Maximum length of 128 characters.
     */
    public val vendor: kotlin.String? = builder.vendor

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmanager.model.CreateDeviceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeviceRequest(")
        append("awsLocation=$awsLocation,")
        append("description=$description,")
        append("globalNetworkId=$globalNetworkId,")
        append("location=*** Sensitive Data Redacted ***,")
        append("model=$model,")
        append("serialNumber=$serialNumber,")
        append("siteId=$siteId,")
        append("tags=$tags,")
        append("type=$type,")
        append("vendor=$vendor)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsLocation?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (globalNetworkId?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (model?.hashCode() ?: 0)
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (siteId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vendor?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeviceRequest

        if (awsLocation != other.awsLocation) return false
        if (description != other.description) return false
        if (globalNetworkId != other.globalNetworkId) return false
        if (location != other.location) return false
        if (model != other.model) return false
        if (serialNumber != other.serialNumber) return false
        if (siteId != other.siteId) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (vendor != other.vendor) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmanager.model.CreateDeviceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.
         */
        public var awsLocation: aws.sdk.kotlin.services.networkmanager.model.AwsLocation? = null
        /**
         * A description of the device.
         *
         * Constraints: Maximum length of 256 characters.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the global network.
         */
        public var globalNetworkId: kotlin.String? = null
        /**
         * The location of the device.
         */
        public var location: aws.sdk.kotlin.services.networkmanager.model.Location? = null
        /**
         * The model of the device.
         *
         * Constraints: Maximum length of 128 characters.
         */
        public var model: kotlin.String? = null
        /**
         * The serial number of the device.
         *
         * Constraints: Maximum length of 128 characters.
         */
        public var serialNumber: kotlin.String? = null
        /**
         * The ID of the site.
         */
        public var siteId: kotlin.String? = null
        /**
         * The tags to apply to the resource during creation.
         */
        public var tags: List<Tag>? = null
        /**
         * The type of the device.
         */
        public var type: kotlin.String? = null
        /**
         * The vendor of the device.
         *
         * Constraints: Maximum length of 128 characters.
         */
        public var vendor: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmanager.model.CreateDeviceRequest) : this() {
            this.awsLocation = x.awsLocation
            this.description = x.description
            this.globalNetworkId = x.globalNetworkId
            this.location = x.location
            this.model = x.model
            this.serialNumber = x.serialNumber
            this.siteId = x.siteId
            this.tags = x.tags
            this.type = x.type
            this.vendor = x.vendor
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmanager.model.CreateDeviceRequest = CreateDeviceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkmanager.model.AwsLocation] inside the given [block]
         */
        public fun awsLocation(block: aws.sdk.kotlin.services.networkmanager.model.AwsLocation.Builder.() -> kotlin.Unit) {
            this.awsLocation = aws.sdk.kotlin.services.networkmanager.model.AwsLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkmanager.model.Location] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.networkmanager.model.Location.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.networkmanager.model.Location.invoke(block)
        }
    }
}
